/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.nio.NioEventLoop;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioFile;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.ReactorNetty;
import reactor.ipc.netty.channel.data.AbstractFileChunkedStrategy;
import reactor.ipc.netty.channel.data.FileChunkedStrategy;

public interface NettyOutbound
extends Publisher<Void> {
    public static final FileChunkedStrategy<ByteBuf> FILE_CHUNKED_STRATEGY_BUFFER = new AbstractFileChunkedStrategy<ByteBuf>(){

        @Override
        public ChunkedInput<ByteBuf> chunkFile(FileChannel fileChannel, long offset, long length, int chunkSize) {
            try {
                return new ChunkedNioFile(fileChannel, offset, length, chunkSize);
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
    };

    default public ByteBufAllocator alloc() {
        return this.context().channel().alloc();
    }

    public NettyContext context();

    default public NettyOutbound context(Consumer<NettyContext> contextCallback) {
        contextCallback.accept(this.context());
        return this;
    }

    default public FileChunkedStrategy<?> getFileChunkedStrategy() {
        return FILE_CHUNKED_STRATEGY_BUFFER;
    }

    default public Mono<Void> neverComplete() {
        return this.then((Publisher<Void>)Mono.never()).then();
    }

    default public NettyOutbound onWriteIdle(long idleTimeout, Runnable onWriteIdle) {
        this.context().removeHandler("reactor.left.onChannelWriteIdle");
        this.context().addHandlerFirst("reactor.left.onChannelWriteIdle", (ChannelHandler)new ReactorNetty.OutboundIdleStateHandler(idleTimeout, onWriteIdle));
        return this;
    }

    default public NettyOutbound options(Consumer<? super NettyPipeline.SendOptions> configurator) {
        this.context().channel().pipeline().fireUserEventTriggered((Object)new NettyPipeline.SendOptionsChangeEvent(configurator, null));
        return this;
    }

    default public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(dataStream);
    }

    default public NettyOutbound sendByteArray(Publisher<? extends byte[]> dataStream) {
        return this.send(ReactorNetty.publisherOrScalarMap(dataStream, Unpooled::wrappedBuffer));
    }

    default public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            return this.then((Publisher<Void>)Mono.error((Throwable)e));
        }
    }

    default public NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        return this.then((Publisher<Void>)Mono.using(() -> FileChannel.open(file, StandardOpenOption.READ), fc -> {
            if (this.context().channel().pipeline().get(SslHandler.class) != null || this.context().channel().pipeline().get("reactor.left.compressionHandler") != null || !(this.context().channel().eventLoop() instanceof NioEventLoop) && !"file".equals(file.toUri().getScheme())) {
                FileChunkedStrategy<?> strategy = this.getFileChunkedStrategy();
                strategy.preparePipeline(this.context());
                try {
                    ChunkedInput<?> message = strategy.chunkFile((FileChannel)fc, position, count, 1024);
                    return FutureMono.from(this.context().channel().writeAndFlush(message));
                }
                catch (Exception e) {
                    return Mono.error((Throwable)e);
                }
            }
            return FutureMono.from(this.context().channel().writeAndFlush((Object)new DefaultFileRegion(fc, position, count)));
        }, fc -> {
            try {
                fc.close();
            }
            catch (IOException iOException) {
            }
            finally {
                if (this.context().channel().pipeline().get("reactor.left.chunkedWriter") != null) {
                    this.getFileChunkedStrategy().cleanupPipeline(this.context());
                }
            }
        }));
    }

    default public NettyOutbound sendFileChunked(Path file, long position, long count) {
        Objects.requireNonNull(file);
        FileChunkedStrategy<?> strategy = this.getFileChunkedStrategy();
        return this.then((Publisher<Void>)Mono.using(() -> FileChannel.open(file, StandardOpenOption.READ), fc -> {
            strategy.preparePipeline(this.context());
            try {
                ChunkedInput message = strategy.chunkFile((FileChannel)fc, position, count, 1024);
                return FutureMono.from(this.context().channel().writeAndFlush(message));
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }, fc -> {
            try {
                fc.close();
            }
            catch (IOException iOException) {
            }
            finally {
                strategy.cleanupPipeline(this.context());
            }
        }));
    }

    default public NettyOutbound sendGroups(Publisher<? extends Publisher<? extends ByteBuf>> dataStreams) {
        return this.then((Publisher<Void>)Flux.from(dataStreams).concatMapDelayError(this::send, false, 32).then());
    }

    default public NettyOutbound sendObject(Publisher<?> dataStream) {
        return this.then((Publisher<Void>)FutureMono.disposableWriteAndFlush(this.context().channel(), dataStream));
    }

    default public NettyOutbound sendObject(Object msg) {
        this.context().onClose(() -> ReactorNetty.safeRelease(msg));
        return this.then((Publisher<Void>)FutureMono.deferFuture(() -> this.context().channel().writeAndFlush(msg)));
    }

    default public NettyOutbound sendString(Publisher<? extends String> dataStream) {
        return this.sendString(dataStream, Charset.defaultCharset());
    }

    default public NettyOutbound sendString(Publisher<? extends String> dataStream, Charset charset) {
        return this.sendObject(ReactorNetty.publisherOrScalarMap(dataStream, s -> this.alloc().buffer().writeBytes(s.getBytes(charset))));
    }

    default public void subscribe(Subscriber<? super Void> s) {
        this.then().subscribe(s);
    }

    default public Mono<Void> then() {
        return Mono.empty();
    }

    default public NettyOutbound then(Publisher<Void> other) {
        return new ReactorNetty.OutboundThen(this, other);
    }
}

