/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.NativeImageStartedNotifier;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.ConfigProvider;

public class NativeImageLauncher
implements Closeable {
    private static final int DEFAULT_PORT = 8081;
    private static final long DEFAULT_IMAGE_WAIT_TIME = 60L;
    private final Class<?> testClass;
    private final String profile;
    private Process quarkusProcess;
    private final int port;
    private final long imageWaitTime;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private List<NativeImageStartedNotifier> startedNotifiers;

    public NativeImageLauncher(Class<?> testClass) {
        this(testClass, ConfigProvider.getConfig().getOptionalValue("quarkus.http.test-port", Integer.class).orElse(8081), ConfigProvider.getConfig().getOptionalValue("quarkus.test.native-image-wait-time", Long.class).orElse(60L), ConfigProvider.getConfig().getOptionalValue("quarkus.test.native-image-profile", String.class).orElse(null));
    }

    public NativeImageLauncher(Class<?> testClass, int port, long imageWaitTime, String profile) {
        this.testClass = testClass;
        this.port = port;
        this.imageWaitTime = imageWaitTime;
        ArrayList<NativeImageStartedNotifier> startedNotifiers = new ArrayList<NativeImageStartedNotifier>();
        for (NativeImageStartedNotifier i : ServiceLoader.load(NativeImageStartedNotifier.class)) {
            startedNotifiers.add(i);
        }
        this.startedNotifiers = startedNotifiers;
        this.profile = profile;
    }

    public void start() throws IOException {
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        String path = System.getProperty("native.image.path");
        if (path == null) {
            path = NativeImageLauncher.guessPath(this.testClass);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(path);
        args.add("-Dquarkus.http.port=" + this.port);
        args.add("-Dtest.url=" + TestHTTPResourceManager.getUri());
        args.add("-Dquarkus.log.file.path=" + PropertyTestUtil.getLogFileLocation());
        if (this.profile != null) {
            args.add("-Dquarkus.profile=" + this.profile);
        }
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            args.add("-D" + e.getKey() + "=" + e.getValue());
        }
        System.out.println("Executing " + args);
        this.quarkusProcess = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        new Thread(new ProcessReader(this.quarkusProcess.getInputStream())).start();
        new Thread(new ProcessReader(this.quarkusProcess.getErrorStream())).start();
        this.waitForQuarkus();
    }

    private static String guessPath(Class<?> testClass) {
        ClassLoader cl = testClass.getClassLoader();
        if (cl instanceof URLClassLoader) {
            URL[] urls;
            for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                File testClasses;
                if (url.getProtocol().equals("file") && url.getPath().endsWith("test-classes/")) {
                    testClasses = new File(url.getPath());
                    for (File file : testClasses.getParentFile().listFiles()) {
                        if (!file.getName().endsWith("-runner")) continue;
                        NativeImageLauncher.logGuessedPath(file.getAbsolutePath());
                        return file.getAbsolutePath();
                    }
                    continue;
                }
                if (!url.getProtocol().equals("file") || !url.getPath().endsWith("test/")) continue;
                testClasses = new File(url.getPath());
                for (File file : testClasses.getParentFile().getParentFile().getParentFile().listFiles()) {
                    if (!file.getName().endsWith("-runner")) continue;
                    NativeImageLauncher.logGuessedPath(file.getAbsolutePath());
                    return file.getAbsolutePath();
                }
            }
        }
        throw new RuntimeException("Unable to find native image, make sure native.image.path is set");
    }

    private static void logGuessedPath(String guessedPath) {
        int i;
        String errorString = "\n=native.image.path was not set, making a guess that  " + guessedPath + " is the correct native image=";
        for (i = 0; i < errorString.length(); ++i) {
            System.err.print("=");
        }
        System.err.println(errorString);
        for (i = 0; i < errorString.length(); ++i) {
            System.err.print("=");
        }
        System.err.println();
    }

    private void waitForQuarkus() {
        long bailout = System.currentTimeMillis() + this.imageWaitTime * 1000L;
        while (System.currentTimeMillis() < bailout) {
            try {
                Thread.sleep(100L);
                for (NativeImageStartedNotifier i : this.startedNotifiers) {
                    if (!i.isNativeImageStarted()) continue;
                    return;
                }
                try (Socket s = new Socket();){
                    s.connect(new InetSocketAddress("localhost", this.port));
                    return;
                }
            }
            catch (Exception exception) {
            }
        }
        throw new RuntimeException("Unable to start native image in " + this.imageWaitTime + "s");
    }

    public void addSystemProperties(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    @Override
    public void close() {
        this.quarkusProcess.destroy();
    }

    private static final class ProcessReader
    implements Runnable {
        private final InputStream inputStream;

        private ProcessReader(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public void run() {
            byte[] b = new byte[100];
            try {
                int i;
                while ((i = this.inputStream.read(b)) > 0) {
                    System.out.print(new String(b, 0, i, StandardCharsets.UTF_8));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

