/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import com.alibaba.fastjson.JSON;
import io.seata.common.util.BlobUtils;
import io.seata.common.util.IOUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.model.Result;
import io.seata.rm.datasource.DataCompareUtils;
import io.seata.rm.datasource.SqlGenerateUtils;
import io.seata.rm.datasource.sql.serial.SerialArray;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.KeyType;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.SQLUndoDirtyException;
import io.seata.rm.datasource.undo.SQLUndoLog;
import io.seata.rm.datasource.util.JdbcUtils;
import io.seata.sqlparser.util.ColumnUtils;
import java.sql.Array;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUndoExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUndoExecutor.class);
    private static final String CHECK_SQL_TEMPLATE = "SELECT * FROM %s WHERE %s FOR UPDATE";
    public static final boolean IS_UNDO_DATA_VALIDATION_ENABLE = ConfigurationFactory.getInstance().getBoolean("client.undo.dataValidation", true);
    protected SQLUndoLog sqlUndoLog;

    protected abstract String buildUndoSQL();

    public AbstractUndoExecutor(SQLUndoLog sqlUndoLog) {
        this.sqlUndoLog = sqlUndoLog;
    }

    public SQLUndoLog getSqlUndoLog() {
        return this.sqlUndoLog;
    }

    public void executeOn(Connection conn) throws SQLException {
        if (IS_UNDO_DATA_VALIDATION_ENABLE && !this.dataValidationAndGoOn(conn)) {
            return;
        }
        PreparedStatement undoPST = null;
        try {
            String undoSQL = this.buildUndoSQL();
            undoPST = conn.prepareStatement(undoSQL);
            TableRecords undoRows = this.getUndoRows();
            for (Row undoRow : undoRows.getRows()) {
                ArrayList<Field> undoValues = new ArrayList<Field>();
                List<Field> pkValueList = this.getOrderedPkList(undoRows, undoRow, this.getDbType(conn));
                for (Field field : undoRow.getFields()) {
                    if (field.getKeyType() == KeyType.PRIMARY_KEY) continue;
                    undoValues.add(field);
                }
                this.undoPrepare(undoPST, undoValues, pkValueList);
                undoPST.executeUpdate();
            }
        }
        catch (Exception ex) {
            try {
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                throw new SQLException(ex);
            }
            catch (Throwable throwable) {
                IOUtil.close(undoPST);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)undoPST);
    }

    protected void undoPrepare(PreparedStatement undoPST, ArrayList<Field> undoValues, List<Field> pkValueList) throws SQLException {
        int undoIndex = 0;
        for (Field undoValue : undoValues) {
            ++undoIndex;
            int type = undoValue.getType();
            Object value = undoValue.getValue();
            if (type == JDBCType.BLOB.getVendorTypeNumber()) {
                SerialBlob serialBlob = (SerialBlob)value;
                if (serialBlob != null) {
                    undoPST.setBytes(undoIndex, BlobUtils.blob2Bytes(serialBlob));
                    continue;
                }
                undoPST.setObject(undoIndex, null);
                continue;
            }
            if (type == JDBCType.CLOB.getVendorTypeNumber() || type == JDBCType.NCLOB.getVendorTypeNumber()) {
                SerialClob serialClob = (SerialClob)value;
                if (serialClob != null) {
                    undoPST.setClob(undoIndex, serialClob.getCharacterStream());
                    continue;
                }
                undoPST.setObject(undoIndex, null);
                continue;
            }
            if (type == JDBCType.DATALINK.getVendorTypeNumber()) {
                SerialDatalink dataLink = (SerialDatalink)value;
                if (dataLink != null) {
                    undoPST.setURL(undoIndex, dataLink.getDatalink());
                    continue;
                }
                undoPST.setObject(undoIndex, null);
                continue;
            }
            if (type == JDBCType.ARRAY.getVendorTypeNumber()) {
                SerialArray array = (SerialArray)value;
                if (array != null) {
                    Array arrayOf = undoPST.getConnection().createArrayOf(array.getBaseTypeName(), array.getElements());
                    undoPST.setArray(undoIndex, arrayOf);
                    continue;
                }
                undoPST.setObject(undoIndex, null);
                continue;
            }
            if (undoValue.getType() == JDBCType.OTHER.getVendorTypeNumber().intValue()) {
                undoPST.setObject(undoIndex, value);
                continue;
            }
            if (undoValue.getType() == JDBCType.BIT.getVendorTypeNumber().intValue()) {
                undoPST.setObject(undoIndex, value);
                continue;
            }
            undoPST.setObject(undoIndex, value, type);
        }
        for (Field pkField : pkValueList) {
            undoPST.setObject(++undoIndex, pkField.getValue(), pkField.getType());
        }
    }

    protected abstract TableRecords getUndoRows();

    protected boolean dataValidationAndGoOn(Connection conn) throws SQLException {
        TableRecords afterRecords;
        TableRecords beforeRecords = this.sqlUndoLog.getBeforeImage();
        Result<Boolean> beforeEqualsAfterResult = DataCompareUtils.isRecordsEquals(beforeRecords, afterRecords = this.sqlUndoLog.getAfterImage());
        if (beforeEqualsAfterResult.getResult().booleanValue()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Stop rollback because there is no data change between the before data snapshot and the after data snapshot.");
            }
            return false;
        }
        TableRecords currentRecords = this.queryCurrentRecords(conn);
        Result<Boolean> afterEqualsCurrentResult = DataCompareUtils.isRecordsEquals(afterRecords, currentRecords);
        if (!afterEqualsCurrentResult.getResult().booleanValue()) {
            Result<Boolean> beforeEqualsCurrentResult = DataCompareUtils.isRecordsEquals(beforeRecords, currentRecords);
            if (beforeEqualsCurrentResult.getResult().booleanValue()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Stop rollback because there is no data change between the before data snapshot and the current data snapshot.");
                }
                return false;
            }
            if (LOGGER.isInfoEnabled() && StringUtils.isNotBlank(afterEqualsCurrentResult.getErrMsg())) {
                LOGGER.info(afterEqualsCurrentResult.getErrMsg(), afterEqualsCurrentResult.getErrMsgParams());
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("check dirty data failed, old and new data are not equal, tableName:[" + this.sqlUndoLog.getTableName() + "],oldRows:[" + JSON.toJSONString(afterRecords.getRows()) + "],newRows:[" + JSON.toJSONString(currentRecords.getRows()) + "].");
            }
            throw new SQLUndoDirtyException("Has dirty records when undo.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableRecords queryCurrentRecords(Connection conn) throws SQLException {
        TableRecords currentRecords;
        TableRecords undoRecords = this.getUndoRows();
        TableMeta tableMeta = undoRecords.getTableMeta();
        List<String> pkNameList = tableMeta.getPrimaryKeyOnlyName();
        Map<String, List<Field>> pkRowValues = this.parsePkValues(this.getUndoRows());
        if (pkRowValues.size() == 0) {
            return TableRecords.empty(tableMeta);
        }
        String firstKey = (String)pkRowValues.keySet().stream().findFirst().get();
        int pkRowSize = pkRowValues.get(firstKey).size();
        String checkSQL = String.format(CHECK_SQL_TEMPLATE, this.sqlUndoLog.getTableName(), SqlGenerateUtils.buildWhereConditionByPKs(pkNameList, pkRowSize, this.getDbType(conn)));
        PreparedStatement statement = null;
        ResultSet checkSet = null;
        try {
            statement = conn.prepareStatement(checkSQL);
            int paramIndex = 1;
            int rowSize = pkRowValues.get(pkNameList.get(0)).size();
            for (int r = 0; r < rowSize; ++r) {
                for (int c = 0; c < pkNameList.size(); ++c) {
                    List<Field> pkColumnValueList = pkRowValues.get(pkNameList.get(c));
                    Field field = pkColumnValueList.get(r);
                    int dataType = tableMeta.getColumnMeta(field.getName()).getDataType();
                    statement.setObject(paramIndex, field.getValue(), dataType);
                    ++paramIndex;
                }
            }
            checkSet = statement.executeQuery();
            currentRecords = TableRecords.buildRecords(tableMeta, checkSet);
        }
        catch (Throwable throwable) {
            IOUtil.close(checkSet, statement);
            throw throwable;
        }
        IOUtil.close(checkSet, statement);
        return currentRecords;
    }

    protected List<Field> getOrderedPkList(TableRecords image, Row row, String dbType) {
        ArrayList<Field> pkFields = new ArrayList<Field>();
        List<String> pkColumnNameListByOrder = image.getTableMeta().getPrimaryKeyOnlyName();
        List pkColumnNameListNoOrder = row.primaryKeys().stream().map(e -> ColumnUtils.delEscape(e.getName(), dbType)).collect(Collectors.toList());
        pkColumnNameListByOrder.forEach(pkName -> {
            int pkIndex = pkColumnNameListNoOrder.indexOf(pkName);
            if (pkIndex != -1) {
                pkFields.add(row.primaryKeys().get(pkIndex));
            }
        });
        return pkFields;
    }

    protected Map<String, List<Field>> parsePkValues(TableRecords records) {
        return this.parsePkValues(records.getRows(), records.getTableMeta().getPrimaryKeyOnlyName());
    }

    protected Map<String, List<Field>> parsePkValues(List<Row> rows, List<String> pkNameList) {
        ArrayList<Field> pkFieldList = new ArrayList<Field>();
        for (int i = 0; i < rows.size(); ++i) {
            List<Field> fields = rows.get(i).getFields();
            if (fields == null) continue;
            for (Field field : fields) {
                if (!pkNameList.stream().anyMatch(e -> field.getName().equalsIgnoreCase((String)e))) continue;
                pkFieldList.add(field);
            }
        }
        Map<String, List<Field>> pkValueMap = pkFieldList.stream().collect(Collectors.groupingBy(Field::getName));
        return pkValueMap;
    }

    protected String getDbType(Connection conn) throws SQLException {
        return JdbcUtils.getDbType(conn.getMetaData().getURL());
    }
}

