/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.engine.unittest;

import io.servicecomb.swagger.engine.SwaggerConsumer;
import io.servicecomb.swagger.engine.SwaggerConsumerOperation;
import io.servicecomb.swagger.engine.SwaggerProducer;
import io.servicecomb.swagger.engine.SwaggerProducerOperation;
import io.servicecomb.swagger.invocation.Response;
import io.servicecomb.swagger.invocation.SwaggerInvocation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class LocalProducerInvoker
implements InvocationHandler {
    private Object proxy;
    private SwaggerConsumer consumer;
    private SwaggerProducer producer;
    private SwaggerInvocation invocation;
    private Response producerResponse;

    public LocalProducerInvoker(SwaggerConsumer consumer, SwaggerProducer producer) {
        this.consumer = consumer;
        this.producer = producer;
        this.proxy = Proxy.newProxyInstance(consumer.getConsumerIntf().getClassLoader(), new Class[]{consumer.getConsumerIntf()}, (InvocationHandler)this);
    }

    public <T> T getProxy() {
        return (T)this.proxy;
    }

    public SwaggerInvocation getInvocation() {
        return this.invocation;
    }

    public <T> T getSwaggerArgument(int idx) {
        return this.invocation.getSwaggerArgument(idx);
    }

    public <T> T getContext(String key) {
        return this.invocation.getContext(key);
    }

    public Response getProducerResponse() {
        return this.producerResponse;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.invocation = new SwaggerInvocation();
        SwaggerConsumerOperation consumerOp = this.consumer.findOperation(method.getName());
        SwaggerProducerOperation producerOp = this.producer.findOperation(method.getName());
        consumerOp.getArgumentsMapper().toInvocation(args, this.invocation);
        this.producerResponse = producerOp.doInvoke(this.invocation);
        return consumerOp.getResponseMapper().mapResponse(this.producerResponse);
    }
}

