/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.arguments;

import io.servicecomb.swagger.invocation.InvocationType;
import io.servicecomb.swagger.invocation.arguments.ArgumentMapper;
import io.servicecomb.swagger.invocation.arguments.ArgumentsMapperConfig;
import io.servicecomb.swagger.invocation.arguments.ContextArgumentMapperFactory;
import io.servicecomb.swagger.invocation.arguments.FieldInfo;
import io.servicecomb.swagger.invocation.arguments.ProviderParameter;
import io.servicecomb.swagger.invocation.converter.Converter;
import io.servicecomb.swagger.invocation.converter.ConverterMgr;
import io.servicecomb.swagger.invocation.converter.impl.ConverterCommon;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.util.TypeUtils;

public abstract class ArgumentsMapperFactory {
    @Inject
    protected ConverterMgr converterMgr;
    protected InvocationType type;
    private Map<Class<?>, ContextArgumentMapperFactory> factoryMap = new HashMap();

    public void setConverterMgr(ConverterMgr converterMgr) {
        this.converterMgr = converterMgr;
    }

    protected void createFactoryMap(List<ContextArgumentMapperFactory> factoryList) {
        factoryList.forEach(factory -> this.factoryMap.put(factory.getContextClass(), (ContextArgumentMapperFactory)factory));
    }

    protected ContextArgumentMapperFactory findFactory(Type type) {
        if (type.getClass().equals(Class.class)) {
            return this.factoryMap.get((Class)type);
        }
        return null;
    }

    public <T> T createArgumentsMapper(Method swaggerMethod, Method providerMethod) {
        ArgumentsMapperConfig config = new ArgumentsMapperConfig();
        config.setSwaggerMethod(swaggerMethod);
        config.setProviderMethod(providerMethod);
        this.collectArgumentsMapper(config);
        return this.createArgumentsMapper(config);
    }

    protected void collectArgumentsMapper(ArgumentsMapperConfig config) {
        List<ProviderParameter> providerNormalParams = this.collectContextArgumentsMapper(config);
        if (providerNormalParams.isEmpty()) {
            return;
        }
        if (this.isSwaggerWrapBody(config, providerNormalParams)) {
            this.collectWrapBodyMapper(config, providerNormalParams);
            return;
        }
        this.collectSwaggerArgumentsMapper(config, providerNormalParams);
    }

    protected boolean isSwaggerWrapBody(ArgumentsMapperConfig config, List<ProviderParameter> providerNormalParams) {
        Method swaggerMethod = config.getSwaggerMethod();
        if (swaggerMethod.getParameterCount() != 1) {
            return false;
        }
        Type swaggerType = config.getSwaggerMethod().getGenericParameterTypes()[0];
        if (!swaggerType.getClass().equals(Class.class)) {
            return false;
        }
        Type firstProviderParam = providerNormalParams.get(0).getType();
        if (TypeUtils.isAssignable((Type)firstProviderParam, (Type)swaggerType)) {
            return false;
        }
        Converter converter = this.converterMgr.findConverter(this.type, firstProviderParam, swaggerType = ((Class)swaggerType).getFields()[0].getGenericType());
        return !ConverterCommon.class.isInstance(converter);
    }

    protected List<ProviderParameter> collectContextArgumentsMapper(ArgumentsMapperConfig config) {
        ArrayList<ProviderParameter> providerNormalParams = new ArrayList<ProviderParameter>();
        Type[] providerParameterTypes = config.getProviderMethod().getGenericParameterTypes();
        for (int providerIdx = 0; providerIdx < providerParameterTypes.length; ++providerIdx) {
            Type parameterType = providerParameterTypes[providerIdx];
            ContextArgumentMapperFactory factory = this.findFactory(parameterType);
            if (factory != null) {
                ArgumentMapper mapper = factory.create(providerIdx);
                config.addArgumentMapper(mapper);
                continue;
            }
            ProviderParameter pp = new ProviderParameter(providerIdx, parameterType);
            providerNormalParams.add(pp);
        }
        return providerNormalParams;
    }

    protected void collectSwaggerArgumentsMapper(ArgumentsMapperConfig config, List<ProviderParameter> providerNormalParams) {
        Method swaggerMethod = config.getSwaggerMethod();
        Type[] swaggerParams = swaggerMethod.getGenericParameterTypes();
        int minParamCount = Math.min(providerNormalParams.size(), swaggerParams.length);
        for (int swaggerIdx = 0; swaggerIdx < minParamCount; ++swaggerIdx) {
            ProviderParameter providerParameter = providerNormalParams.get(swaggerIdx);
            Type swaggerParameter = swaggerParams[swaggerIdx];
            Converter converter = this.converterMgr.findConverter(this.type, providerParameter.getType(), swaggerParameter);
            ArgumentMapper mapper = this.createArgumentMapperWithConverter(swaggerIdx, providerParameter.getIndex(), converter);
            config.addArgumentMapper(mapper);
        }
    }

    protected void collectWrapBodyMapper(ArgumentsMapperConfig config, List<ProviderParameter> providerNormalParams) {
        Method swaggerMethod = config.getSwaggerMethod();
        Class<?> swaggerParam = swaggerMethod.getParameterTypes()[0];
        Field[] swaggerParamFields = swaggerParam.getFields();
        int minParamCount = Math.min(providerNormalParams.size(), swaggerParamFields.length);
        HashMap<Integer, FieldInfo> fieldMap = new HashMap<Integer, FieldInfo>();
        for (int swaggerIdx = 0; swaggerIdx < minParamCount; ++swaggerIdx) {
            ProviderParameter providerParameter = providerNormalParams.get(swaggerIdx);
            Field swaggerField = swaggerParamFields[swaggerIdx];
            swaggerField.setAccessible(true);
            Converter converter = this.converterMgr.findConverter(this.type, providerParameter.getType(), swaggerField.getGenericType());
            FieldInfo info = new FieldInfo(swaggerField, converter);
            fieldMap.put(providerParameter.getIndex(), info);
        }
        ArgumentMapper bodyFieldArg = this.createBodyFieldArgMapper(config, fieldMap);
        config.addArgumentMapper(bodyFieldArg);
    }

    protected abstract <T> T createArgumentsMapper(ArgumentsMapperConfig var1);

    protected abstract ArgumentMapper createArgumentMapperWithConverter(int var1, int var2, Converter var3);

    protected abstract ArgumentMapper createBodyFieldArgMapper(ArgumentsMapperConfig var1, Map<Integer, FieldInfo> var2);
}

