/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.swagger.invocation.converter;

import io.servicecomb.swagger.invocation.InvocationType;
import io.servicecomb.swagger.invocation.converter.Converter;
import io.servicecomb.swagger.invocation.converter.CustomizedConverter;
import io.servicecomb.swagger.invocation.converter.impl.ConverterCommon;
import io.servicecomb.swagger.invocation.converter.impl.ConverterSame;
import io.servicecomb.swagger.invocation.converter.impl.SameElementArrayToList;
import io.servicecomb.swagger.invocation.converter.impl.SameElementArrayToSet;
import io.servicecomb.swagger.invocation.converter.impl.SameElementCollectionToArray;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConverterMgr {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConverterMgr.class);
    private Map<Type, Map<Type, Converter>> srcTargetMap = new HashMap<Type, Map<Type, Converter>>();
    private Map<Type, Converter> commonMap = new ConcurrentHashMap<Type, Converter>();
    private Converter same = ConverterSame.getInstance();
    private Converter arrayToList = SameElementArrayToList.getInstance();
    private Converter arrayToSet = SameElementArrayToSet.getInstance();
    private Map<Type, Converter> collectionToArrayMap = new ConcurrentHashMap<Type, Converter>();

    @Autowired(required=false)
    public void setCustomizedConverters(List<CustomizedConverter> converters) {
        for (CustomizedConverter converter : converters) {
            Map<Type, Converter> map = this.srcTargetMap.get(converter.getSrcType());
            if (map == null) {
                map = new HashMap<Type, Converter>();
                this.srcTargetMap.put(converter.getSrcType(), map);
            }
            map.put(converter.getTargetType(), converter);
        }
    }

    public Converter findConverter(InvocationType invocationType, Type provider, Type swagger) {
        if (InvocationType.CONSUMER.equals((Object)invocationType)) {
            return this.findConverter(provider, swagger);
        }
        return this.findConverter(swagger, provider);
    }

    public Converter findConverter(Type src, Type target) {
        Converter converter = this.findSrcTarget(src, target);
        if (converter != null) {
            return converter;
        }
        converter = this.findAssignable(src, target);
        if (converter != null) {
            return converter;
        }
        converter = this.findCollectionToArray(src, target);
        if (converter != null) {
            return converter;
        }
        converter = this.findArrayToCollection(src, target);
        if (converter != null) {
            return converter;
        }
        LOGGER.warn("Bad practice, low performance, convert from {} to {}", (Object)src, (Object)target);
        return this.findCommonConverter(target);
    }

    protected Converter findSrcTarget(Type src, Type target) {
        Map<Type, Converter> map = this.srcTargetMap.get(src);
        if (map == null) {
            return null;
        }
        return map.get(target);
    }

    protected Converter findCommonConverter(Type target) {
        Converter converter = this.commonMap.get(target);
        if (converter != null) {
            return converter;
        }
        converter = new ConverterCommon(target);
        this.commonMap.put(target, converter);
        return converter;
    }

    protected Converter findArrayToCollection(Type src, Type target) {
        if (src.getClass().equals(Class.class) && ParameterizedType.class.isAssignableFrom(target.getClass())) {
            Class srcCls = (Class)src;
            ParameterizedType targetType = (ParameterizedType)target;
            Class targetCls = (Class)targetType.getRawType();
            if (srcCls.isArray() && srcCls.getComponentType().equals(targetType.getActualTypeArguments()[0])) {
                if (List.class.isAssignableFrom(targetCls)) {
                    return this.arrayToList;
                }
                if (Set.class.isAssignableFrom(targetCls)) {
                    return this.arrayToSet;
                }
            }
        }
        return null;
    }

    protected Converter findAssignable(Type src, Type target) {
        if (TypeUtils.isAssignable((Type)src, (Type)target)) {
            return this.same;
        }
        return null;
    }

    protected Converter findCollectionToArray(Type src, Type target) {
        if (ParameterizedType.class.isAssignableFrom(src.getClass()) && target.getClass().equals(Class.class)) {
            ParameterizedType srcType = (ParameterizedType)src;
            Class srcCls = (Class)srcType.getRawType();
            Class targetCls = (Class)target;
            if (Collection.class.isAssignableFrom(srcCls) && targetCls.isArray() && srcType.getActualTypeArguments()[0].equals(targetCls.getComponentType())) {
                Converter converter = this.collectionToArrayMap.get(target);
                if (converter == null) {
                    converter = new SameElementCollectionToArray(targetCls.getComponentType());
                    this.collectionToArrayMap.put(target, converter);
                }
                return converter;
            }
        }
        return null;
    }
}

