/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.spies.MultiSpyBase;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.tuples.Tuple2;

public class MultiOnTerminationSpy<T>
extends MultiSpyBase<T> {
    private volatile Tuple2<Throwable, Boolean> lastTermination;

    public Throwable lastTerminationFailure() throws IllegalStateException {
        return this.lastTermination == null ? null : this.lastTermination.getItem1();
    }

    public boolean lastTerminationWasCancelled() throws IllegalStateException {
        return this.lastTermination != null && this.lastTermination.getItem2() != false;
    }

    @Override
    public void reset() {
        super.reset();
        this.lastTermination = null;
    }

    MultiOnTerminationSpy(Multi<? extends T> upstream) {
        super(upstream);
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.onTermination().invoke((Throwable failure, Boolean cancelled) -> {
            this.lastTermination = Tuple2.of(failure, cancelled);
            this.incrementInvocationCount();
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "MultiOnTerminationSpy{lastTermination=" + String.valueOf(this.lastTermination) + "} " + super.toString();
    }
}

