/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common.impl;

import io.vertx.core.Handler;
import io.vertx.kafka.client.common.Node;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.RecordMetadata;

public class Helper {
    private Helper() {
    }

    public static <T> Set<T> toSet(Collection<T> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        return new HashSet<T>(collection);
    }

    public static org.apache.kafka.common.TopicPartition to(TopicPartition topicPartition) {
        return new org.apache.kafka.common.TopicPartition(topicPartition.getTopic(), topicPartition.getPartition());
    }

    public static Set<org.apache.kafka.common.TopicPartition> to(Set<TopicPartition> topicPartitions) {
        return topicPartitions.stream().map(Helper::to).collect(Collectors.toSet());
    }

    public static Map<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata> to(Map<TopicPartition, OffsetAndMetadata> offsets) {
        return offsets.entrySet().stream().collect(Collectors.toMap(e -> new org.apache.kafka.common.TopicPartition(((TopicPartition)e.getKey()).getTopic(), ((TopicPartition)e.getKey()).getPartition()), e -> new org.apache.kafka.clients.consumer.OffsetAndMetadata(((OffsetAndMetadata)e.getValue()).getOffset(), ((OffsetAndMetadata)e.getValue()).getMetadata())));
    }

    public static Map<TopicPartition, OffsetAndMetadata> from(Map<org.apache.kafka.common.TopicPartition, org.apache.kafka.clients.consumer.OffsetAndMetadata> offsets) {
        return offsets.entrySet().stream().collect(Collectors.toMap(e -> new TopicPartition(((org.apache.kafka.common.TopicPartition)e.getKey()).topic(), ((org.apache.kafka.common.TopicPartition)e.getKey()).partition()), e -> new OffsetAndMetadata(((org.apache.kafka.clients.consumer.OffsetAndMetadata)e.getValue()).offset(), ((org.apache.kafka.clients.consumer.OffsetAndMetadata)e.getValue()).metadata())));
    }

    public static TopicPartition from(org.apache.kafka.common.TopicPartition topicPartition) {
        return new TopicPartition(topicPartition.topic(), topicPartition.partition());
    }

    public static Set<TopicPartition> from(Collection<org.apache.kafka.common.TopicPartition> topicPartitions) {
        return topicPartitions.stream().map(Helper::from).collect(Collectors.toSet());
    }

    public static Handler<Set<org.apache.kafka.common.TopicPartition>> adaptHandler(Handler<Set<TopicPartition>> handler) {
        if (handler != null) {
            return topicPartitions -> handler.handle(Helper.from(topicPartitions));
        }
        return null;
    }

    public static Node from(org.apache.kafka.common.Node node) {
        return new Node(node.hasRack(), node.host(), node.id(), node.idString(), node.isEmpty(), node.port(), node.rack());
    }

    public static io.vertx.kafka.client.producer.RecordMetadata from(RecordMetadata metadata) {
        return new io.vertx.kafka.client.producer.RecordMetadata(metadata.checksum(), metadata.offset(), metadata.partition(), metadata.timestamp(), metadata.topic());
    }

    public static OffsetAndMetadata from(org.apache.kafka.clients.consumer.OffsetAndMetadata offsetAndMetadata) {
        return new OffsetAndMetadata(offsetAndMetadata.offset(), offsetAndMetadata.metadata());
    }

    public static org.apache.kafka.clients.consumer.OffsetAndMetadata to(OffsetAndMetadata offsetAndMetadata) {
        return new org.apache.kafka.clients.consumer.OffsetAndMetadata(offsetAndMetadata.getOffset(), offsetAndMetadata.getMetadata());
    }

    public static Map<TopicPartition, Long> fromTopicPartitionOffsets(Map<org.apache.kafka.common.TopicPartition, Long> offsets) {
        return offsets.entrySet().stream().collect(Collectors.toMap(e -> new TopicPartition(((org.apache.kafka.common.TopicPartition)e.getKey()).topic(), ((org.apache.kafka.common.TopicPartition)e.getKey()).partition()), Map.Entry::getValue));
    }

    public static Map<org.apache.kafka.common.TopicPartition, Long> toTopicPartitionTimes(Map<TopicPartition, Long> topicPartitionTimes) {
        return topicPartitionTimes.entrySet().stream().collect(Collectors.toMap(e -> new org.apache.kafka.common.TopicPartition(((TopicPartition)e.getKey()).getTopic(), ((TopicPartition)e.getKey()).getPartition()), Map.Entry::getValue));
    }

    public static Map<TopicPartition, io.vertx.kafka.client.consumer.OffsetAndTimestamp> fromTopicPartitionOffsetAndTimestamp(Map<org.apache.kafka.common.TopicPartition, OffsetAndTimestamp> topicPartitionOffsetAndTimestamps) {
        return topicPartitionOffsetAndTimestamps.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> new TopicPartition(((org.apache.kafka.common.TopicPartition)e.getKey()).topic(), ((org.apache.kafka.common.TopicPartition)e.getKey()).partition()), e -> new io.vertx.kafka.client.consumer.OffsetAndTimestamp(((OffsetAndTimestamp)e.getValue()).offset(), ((OffsetAndTimestamp)e.getValue()).timestamp())));
    }
}

