/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.util.GroupHitDeserializer;
import io.weaviate.client.v1.graphql.model.GraphQLGetBaseObject;
import io.weaviate.client.v1.graphql.model.GraphQLTypedResponse;
import java.lang.reflect.Type;

public class Serializer {
    private Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    public <C> GraphQLTypedResponse<C> toGraphQLTypedResponse(String response, Class<C> classOfT) {
        Gson gsonTyped = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(GraphQLGetBaseObject.Additional.Group.GroupHit.class, (Object)new GroupHitDeserializer()).create();
        return (GraphQLTypedResponse)gsonTyped.fromJson(response, TypeToken.getParameterized(GraphQLTypedResponse.class, (Type[])new Type[]{classOfT}).getType());
    }

    public <C> C toResponse(String response, Type typeOfT) {
        return (C)this.gson.fromJson(response, typeOfT);
    }

    public <T> T toResponse(String response, Class<T> classOfT) {
        return (T)this.gson.fromJson(response, classOfT);
    }

    public String toJsonString(Object object) {
        return object != null ? this.gson.toJson(object) : null;
    }

    public <T> Result<T> toResult(int statusCode, String body, Class<T> classOfT) {
        if (statusCode < 399) {
            return new Result<T>(this.toResponse(statusCode, body, classOfT));
        }
        return new Result<Object>(statusCode, null, this.toWeaviateError(body));
    }

    public <T> Response<T> toResponse(int statusCode, String body, Class<T> classOfT) {
        if (statusCode < 399) {
            T obj = this.toResponse(body, classOfT);
            return new Response<T>(statusCode, obj, null);
        }
        return new Response<Object>(statusCode, null, this.toWeaviateError(body));
    }

    public <C> Response<GraphQLTypedResponse<C>> toGraphQLTypedResponse(int statusCode, String body, Class<C> classOfC) {
        if (statusCode < 399) {
            GraphQLTypedResponse<C> obj = this.toGraphQLTypedResponse(body, classOfC);
            return new Response<GraphQLTypedResponse<C>>(statusCode, obj, null);
        }
        return new Response<Object>(statusCode, null, this.toWeaviateError(body));
    }

    public <C> Result<GraphQLTypedResponse<C>> toGraphQLTypedResult(int statusCode, String body, Class<C> classOfC) {
        if (statusCode < 399) {
            return new Result<GraphQLTypedResponse<C>>(this.toGraphQLTypedResponse(statusCode, body, classOfC));
        }
        return new Result<Object>(statusCode, null, this.toWeaviateError(body));
    }

    public WeaviateErrorResponse toWeaviateError(String body) {
        return this.toResponse(body, WeaviateErrorResponse.class);
    }
}

