/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.Targets;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;

public class NearVectorArgument
implements Argument {
    private final Float[] vector;
    private final Float certainty;
    private final Float distance;
    private final String[] targetVectors;
    private final Map<String, Float[][]> vectorsPerTarget;
    private final Targets targets;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (this.vector != null) {
            arg.add(String.format("vector:%s", Serializer.array(this.vector)));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty:%s", this.certainty));
        }
        if (this.distance != null) {
            arg.add(String.format("distance:%s", this.distance));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        if (this.vectorsPerTarget != null && !this.vectorsPerTarget.isEmpty()) {
            LinkedHashSet<String> vectorPerTargetArg = new LinkedHashSet<String>();
            for (Map.Entry<String, Float[][]> e : this.vectorsPerTarget.entrySet()) {
                Float[][] vectors = e.getValue();
                vectorPerTargetArg.add(String.format("%s:%s", e.getKey(), vectors.length == 1 ? Serializer.array(vectors[0]) : Serializer.array(vectors)));
            }
            arg.add(String.format("vectorPerTarget:{%s}", String.join((CharSequence)" ", vectorPerTargetArg)));
        }
        if (this.targets != null) {
            arg.add(String.format("%s", this.withValidTargetVectors(this.targets).build()));
        }
        return String.format("nearVector:{%s}", String.join((CharSequence)" ", arg));
    }

    private Targets withValidTargetVectors(Targets targets) {
        return Targets.builder().combinationMethod(targets.getCombinationMethod()).weightsMulti(targets.getWeights()).targetVectors(this.prepareTargetVectors(targets.getTargetVectors())).build();
    }

    private String[] prepareTargetVectors(String[] targets) {
        ArrayList<String> out = new ArrayList<String>();
        for (String target : targets) {
            if (this.vectorsPerTarget.containsKey(target)) {
                int l = this.vectorsPerTarget.get(target).length;
                for (int i = 0; i < l; ++i) {
                    out.add(target);
                }
                continue;
            }
            out.add(target);
        }
        return out.toArray(new String[0]);
    }

    @Generated
    NearVectorArgument(Float[] vector, Float certainty, Float distance, String[] targetVectors, Map<String, Float[][]> vectorsPerTarget, Targets targets) {
        this.vector = vector;
        this.certainty = certainty;
        this.distance = distance;
        this.targetVectors = targetVectors;
        this.vectorsPerTarget = vectorsPerTarget;
        this.targets = targets;
    }

    @Generated
    public static NearVectorArgumentBuilder builder() {
        return new NearVectorArgumentBuilder();
    }

    @Generated
    public Float[] getVector() {
        return this.vector;
    }

    @Generated
    public Float getCertainty() {
        return this.certainty;
    }

    @Generated
    public Float getDistance() {
        return this.distance;
    }

    @Generated
    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    @Generated
    public Map<String, Float[][]> getVectorsPerTarget() {
        return this.vectorsPerTarget;
    }

    @Generated
    public Targets getTargets() {
        return this.targets;
    }

    @Generated
    public String toString() {
        return "NearVectorArgument(vector=" + Arrays.deepToString(this.getVector()) + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ", vectorsPerTarget=" + this.getVectorsPerTarget() + ", targets=" + this.getTargets() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearVectorArgument)) {
            return false;
        }
        NearVectorArgument other = (NearVectorArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVector(), other.getVector())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors())) {
            return false;
        }
        Map<String, Float[][]> this$vectorsPerTarget = this.getVectorsPerTarget();
        Map<String, Float[][]> other$vectorsPerTarget = other.getVectorsPerTarget();
        if (this$vectorsPerTarget == null ? other$vectorsPerTarget != null : !((Object)this$vectorsPerTarget).equals(other$vectorsPerTarget)) {
            return false;
        }
        Targets this$targets = this.getTargets();
        Targets other$targets = other.getTargets();
        return !(this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NearVectorArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getVector());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        Map<String, Float[][]> $vectorsPerTarget = this.getVectorsPerTarget();
        result = result * 59 + ($vectorsPerTarget == null ? 43 : ((Object)$vectorsPerTarget).hashCode());
        Targets $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        return result;
    }

    public static class NearVectorArgumentBuilder {
        @Generated
        private Float[] vector;
        @Generated
        private Float certainty;
        @Generated
        private Float distance;
        @Generated
        private String[] targetVectors;
        @Generated
        private Targets targets;
        Map<String, Float[][]> vectorsPerTarget = new LinkedHashMap<String, Float[][]>();

        public NearVectorArgumentBuilder vectorPerTarget(Map<String, Float[]> vectors) {
            this.vectorsPerTarget.clear();
            for (Map.Entry<String, Float[]> e : vectors.entrySet()) {
                this.vectorsPerTarget.put(e.getKey(), new Float[][]{e.getValue()});
            }
            return this;
        }

        public NearVectorArgumentBuilder vectorsPerTarget(Map<String, Float[][]> vectors) {
            this.vectorsPerTarget = vectors;
            return this;
        }

        @Generated
        NearVectorArgumentBuilder() {
        }

        @Generated
        public NearVectorArgumentBuilder vector(Float[] vector) {
            this.vector = vector;
            return this;
        }

        @Generated
        public NearVectorArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        @Generated
        public NearVectorArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        @Generated
        public NearVectorArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        @Generated
        public NearVectorArgumentBuilder targets(Targets targets) {
            this.targets = targets;
            return this;
        }

        @Generated
        public NearVectorArgument build() {
            return new NearVectorArgument(this.vector, this.certainty, this.distance, this.targetVectors, this.vectorsPerTarget, this.targets);
        }

        @Generated
        public String toString() {
            return "NearVectorArgument.NearVectorArgumentBuilder(vector=" + Arrays.deepToString(this.vector) + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ", vectorsPerTarget=" + this.vectorsPerTarget + ", targets=" + this.targets + ")";
        }
    }
}

