/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base;

import io.weaviate.client.base.Response;
import io.weaviate.client.base.WeaviateError;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;

public class Result<T> {
    private final T result;
    private final WeaviateError error;

    public Result(Response<T> response) {
        this(response.getStatusCode(), response.getBody(), response.getErrors());
    }

    public Result(int statusCode, T body, WeaviateErrorResponse errors) {
        if (errors != null && errors.getError() != null) {
            List<WeaviateErrorMessage> items = errors.getError().stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.error = new WeaviateError(statusCode, items);
            this.result = body;
        } else if (errors != null && errors.getMessage() != null) {
            this.error = new WeaviateError(statusCode, Collections.singletonList(WeaviateErrorMessage.builder().message(errors.getMessage()).build()));
            this.result = body;
        } else {
            this.result = body;
            this.error = null;
        }
    }

    public boolean hasErrors() {
        return this.error != null;
    }

    public <C> Result<C> toErrorResult() {
        return new Result<Object>(this.error.getStatusCode(), null, WeaviateErrorResponse.builder().error(this.error.getMessages()).build());
    }

    @Generated
    public T getResult() {
        return this.result;
    }

    @Generated
    public WeaviateError getError() {
        return this.error;
    }

    @Generated
    public String toString() {
        return "Result(result=" + this.getResult() + ", error=" + this.getError() + ")";
    }
}

