/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base.grpc;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.stub.MetadataUtils;
import io.weaviate.client.Config;
import io.weaviate.client.base.grpc.base.BaseGrpcClient;
import io.weaviate.client.grpc.protocol.v1.WeaviateGrpc;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBatch;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;

public class GrpcClient
extends BaseGrpcClient {
    private final WeaviateGrpc.WeaviateBlockingStub client;
    private final ManagedChannel channel;

    private GrpcClient(WeaviateGrpc.WeaviateBlockingStub client, ManagedChannel channel) {
        this.client = client;
        this.channel = channel;
    }

    public WeaviateProtoBatch.BatchObjectsReply batchObjects(WeaviateProtoBatch.BatchObjectsRequest request) {
        return this.client.batchObjects(request);
    }

    public void shutdown() {
        this.channel.shutdown();
    }

    public static GrpcClient create(Config config, AccessTokenProvider tokenProvider) {
        Metadata headers = GrpcClient.getHeaders(config, tokenProvider);
        ManagedChannel channel = GrpcClient.buildChannel(config);
        WeaviateGrpc.WeaviateBlockingStub blockingStub = WeaviateGrpc.newBlockingStub((Channel)channel);
        WeaviateGrpc.WeaviateBlockingStub client = (WeaviateGrpc.WeaviateBlockingStub)blockingStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)headers)});
        return new GrpcClient(client, channel);
    }
}

