/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base.util;

import io.weaviate.client.base.util.DbVersionProvider;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class DbVersionSupport {
    private final DbVersionProvider provider;

    public boolean supportsClassNameNamespacedEndpoints() {
        return this.satisfiesVersion(1, 14);
    }

    public boolean supportsOnly100TenantsInOneRequest() {
        return this.satisfiesVersion(1, 26);
    }

    private boolean satisfiesVersion(int major, int minor) {
        String[] versionNumbers = StringUtils.split((String)this.provider.getVersion(), (String)".");
        if (versionNumbers != null && versionNumbers.length >= 2) {
            int parsedMajor = Integer.parseInt(versionNumbers[0]);
            int parsedMinor = Integer.parseInt(versionNumbers[1]);
            return parsedMajor == major && parsedMinor >= minor || parsedMajor >= 2;
        }
        return false;
    }

    public void warnDeprecatedNonClassNameNamespacedEndpointsForObjects() {
        System.err.printf("WARNING: Usage of objects paths without className is deprecated in Weaviate %s. Please provide className parameter\n", this.provider.getVersion());
    }

    public void warnDeprecatedNonClassNameNamespacedEndpointsForReferences() {
        System.err.printf("WARNING: Usage of references paths without className is deprecated in Weaviate %s. Please provide className parameter\n", this.provider.getVersion());
    }

    public void warnDeprecatedNonClassNameNamespacedEndpointsForBeacons() {
        System.err.printf("WARNING: Usage of beacon paths without className is deprecated in Weaviate %s. Please provide className parameter\n", this.provider.getVersion());
    }

    public void warnNotSupportedClassNamespacedEndpointsForObjects() {
        System.err.printf("WARNING: Usage of objects paths with className is not supported in Weaviate %s. className parameter is ignored\n", this.provider.getVersion());
    }

    public void warnNotSupportedClassParameterInEndpointsForObjects() {
        System.err.printf("WARNING: Usage of objects paths with class query parameter is not supported in Weaviate %s. class query parameter is ignored\n", this.provider.getVersion());
    }

    public void warnNotSupportedClassNamespacedEndpointsForReferences() {
        System.err.printf("WARNING: Usage of references paths with className is not supported in Weaviate %s. className parameter is ignored\n", this.provider.getVersion());
    }

    public void warnNotSupportedClassNamespacedEndpointsForBeacons() {
        System.err.printf("WARNING: Usage of beacons paths with className is not supported in Weaviate %s. className parameter is ignored\n", this.provider.getVersion());
    }

    @Generated
    public DbVersionSupport(DbVersionProvider provider) {
        this.provider = provider;
    }
}

