/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.async.backup.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.Config;
import io.weaviate.client.base.AsyncBaseClient;
import io.weaviate.client.base.AsyncClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateError;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.util.Futures;
import io.weaviate.client.base.util.UrlEncoder;
import io.weaviate.client.v1.async.backup.api.BackupCreateStatusGetter;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.backup.model.BackupCreateResponse;
import io.weaviate.client.v1.backup.model.BackupCreateStatusResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.concurrent.FutureCallback;

public class BackupCreator
extends AsyncBaseClient<BackupCreateResponse>
implements AsyncClientResult<BackupCreateResponse> {
    private static final long WAIT_INTERVAL = 1000L;
    private final BackupCreateStatusGetter statusGetter;
    private String[] includeClassNames;
    private String[] excludeClassNames;
    private String backend;
    private String backupId;
    private BackupCreateConfig config;
    private boolean waitForCompletion;
    private final Executor executor;

    public BackupCreator(CloseableHttpAsyncClient client, Config config, AccessTokenProvider tokenProvider, BackupCreateStatusGetter statusGetter, Executor executor) {
        super(client, config, tokenProvider);
        this.statusGetter = statusGetter;
        this.executor = executor;
    }

    public BackupCreator withIncludeClassNames(String ... classNames) {
        this.includeClassNames = classNames;
        return this;
    }

    public BackupCreator withExcludeClassNames(String ... classNames) {
        this.excludeClassNames = classNames;
        return this;
    }

    public BackupCreator withBackend(String backend) {
        this.backend = backend;
        return this;
    }

    public BackupCreator withBackupId(String backupId) {
        this.backupId = backupId;
        return this;
    }

    public BackupCreator withConfig(BackupCreateConfig config) {
        this.config = config;
        return this;
    }

    public BackupCreator withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    @Override
    public Future<Result<BackupCreateResponse>> run(FutureCallback<Result<BackupCreateResponse>> callback) {
        if (this.waitForCompletion) {
            return this.createAndWaitForCompletion(callback);
        }
        return this.create(callback);
    }

    private Future<Result<BackupCreateResponse>> create(FutureCallback<Result<BackupCreateResponse>> callback) {
        BackupCreate payload = BackupCreate.builder().id(this.backupId).config(this.config).include(this.includeClassNames).exclude(this.excludeClassNames).build();
        String path = String.format("/backups/%s", UrlEncoder.encodePathParam(this.backend));
        return this.sendPostRequest(path, (Object)payload, BackupCreateResponse.class, callback);
    }

    private Future<Result<BackupCreateResponse>> createAndWaitForCompletion(final FutureCallback<Result<BackupCreateResponse>> callback) {
        final CompletableFuture future = new CompletableFuture();
        FutureCallback<Result<BackupCreateResponse>> internalCallback = new FutureCallback<Result<BackupCreateResponse>>(){

            public void completed(Result<BackupCreateResponse> backupCreateResult) {
                future.complete(backupCreateResult);
            }

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void cancelled() {
                future.cancel(true);
                if (callback != null) {
                    callback.cancelled();
                }
            }
        };
        this.create(internalCallback);
        return ((CompletableFuture)future.thenCompose(createResult -> {
            if (createResult.hasErrors()) {
                return CompletableFuture.completedFuture(createResult);
            }
            return this.getStatusRecursively(this.backend, this.backupId, (Result<BackupCreateResponse>)createResult);
        })).whenComplete((createResult, throwable) -> {
            if (callback != null) {
                if (throwable != null) {
                    callback.failed((Exception)throwable);
                } else {
                    callback.completed(createResult);
                }
            }
        });
    }

    private CompletableFuture<Result<BackupCreateStatusResponse>> getStatus(String backend, String backupId) {
        final CompletableFuture<Result<BackupCreateStatusResponse>> future = new CompletableFuture<Result<BackupCreateStatusResponse>>();
        this.statusGetter.withBackend(backend).withBackupId(backupId).run(new FutureCallback<Result<BackupCreateStatusResponse>>(){

            public void completed(Result<BackupCreateStatusResponse> createStatusResult) {
                future.complete(createStatusResult);
            }

            public void failed(Exception e) {
                future.completeExceptionally(e);
            }

            public void cancelled() {
            }
        });
        return future;
    }

    private CompletableFuture<Result<BackupCreateResponse>> getStatusRecursively(String backend, String backupId, Result<BackupCreateResponse> createResult) {
        return Futures.thenComposeAsync(this.getStatus(backend, backupId), createStatusResult -> {
            boolean isRunning = Optional.of(createStatusResult).filter(r -> !r.hasErrors()).map(Result::getResult).map(BackupCreateStatusResponse::getStatus).filter(status -> {
                switch (status) {
                    case "SUCCESS": 
                    case "FAILED": {
                        return false;
                    }
                }
                return true;
            }).isPresent();
            if (isRunning) {
                try {
                    return Futures.supplyDelayed(() -> this.getStatusRecursively(backend, backupId, createResult), 1000L, this.executor);
                }
                catch (InterruptedException e) {
                    throw new CompletionException(e);
                }
            }
            return CompletableFuture.completedFuture(this.merge((Result<BackupCreateStatusResponse>)createStatusResult, createResult));
        }, this.executor);
    }

    private Result<BackupCreateResponse> merge(Result<BackupCreateStatusResponse> createStatusResult, Result<BackupCreateResponse> createResult) {
        BackupCreateStatusResponse createStatusResponse = createStatusResult.getResult();
        BackupCreateResponse createResponse = createResult.getResult();
        BackupCreateResponse merged = null;
        int statusCode = 200;
        WeaviateErrorResponse errorResponse = null;
        if (createStatusResponse != null) {
            merged = new BackupCreateResponse();
            merged.setId(createStatusResponse.getId());
            merged.setBackend(createStatusResponse.getBackend());
            merged.setPath(createStatusResponse.getPath());
            merged.setStatus(createStatusResponse.getStatus());
            merged.setError(createStatusResponse.getError());
            merged.setClassNames(createResponse.getClassNames());
        }
        if (createStatusResult.hasErrors()) {
            WeaviateError error = createStatusResult.getError();
            statusCode = error.getStatusCode();
            List<WeaviateErrorMessage> messages = error.getMessages();
            errorResponse = WeaviateErrorResponse.builder().code(statusCode).error(messages).build();
        }
        return new Result<BackupCreateResponse>(statusCode, merged, errorResponse);
    }

    public static interface BackupCompression {
        public static final String DEFAULT_COMPRESSION = "DefaultCompression";
        public static final String BEST_SPEED = "BestSpeed";
        public static final String BEST_COMPRESSION = "BestCompression";
    }

    public static class BackupCreateConfig {
        @SerializedName(value="CPUPercentage")
        Integer cpuPercentage;
        @SerializedName(value="ChunkSize")
        Integer chunkSize;
        @SerializedName(value="CompressionLevel")
        String compressionLevel;
        @SerializedName(value="Bucket")
        String bucket;
        @SerializedName(value="Path")
        String path;

        @Generated
        BackupCreateConfig(Integer cpuPercentage, Integer chunkSize, String compressionLevel, String bucket, String path) {
            this.cpuPercentage = cpuPercentage;
            this.chunkSize = chunkSize;
            this.compressionLevel = compressionLevel;
            this.bucket = bucket;
            this.path = path;
        }

        @Generated
        public static BackupCreateConfigBuilder builder() {
            return new BackupCreateConfigBuilder();
        }

        @Generated
        public Integer getCpuPercentage() {
            return this.cpuPercentage;
        }

        @Generated
        public Integer getChunkSize() {
            return this.chunkSize;
        }

        @Generated
        public String getCompressionLevel() {
            return this.compressionLevel;
        }

        @Generated
        public String getBucket() {
            return this.bucket;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public static class BackupCreateConfigBuilder {
            @Generated
            private Integer cpuPercentage;
            @Generated
            private Integer chunkSize;
            @Generated
            private String compressionLevel;
            @Generated
            private String bucket;
            @Generated
            private String path;

            @Generated
            BackupCreateConfigBuilder() {
            }

            @Generated
            public BackupCreateConfigBuilder cpuPercentage(Integer cpuPercentage) {
                this.cpuPercentage = cpuPercentage;
                return this;
            }

            @Generated
            public BackupCreateConfigBuilder chunkSize(Integer chunkSize) {
                this.chunkSize = chunkSize;
                return this;
            }

            @Generated
            public BackupCreateConfigBuilder compressionLevel(String compressionLevel) {
                this.compressionLevel = compressionLevel;
                return this;
            }

            @Generated
            public BackupCreateConfigBuilder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            @Generated
            public BackupCreateConfigBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public BackupCreateConfig build() {
                return new BackupCreateConfig(this.cpuPercentage, this.chunkSize, this.compressionLevel, this.bucket, this.path);
            }

            @Generated
            public String toString() {
                return "BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder(cpuPercentage=" + this.cpuPercentage + ", chunkSize=" + this.chunkSize + ", compressionLevel=" + this.compressionLevel + ", bucket=" + this.bucket + ", path=" + this.path + ")";
            }
        }
    }

    private static class BackupCreate {
        String id;
        String[] include;
        String[] exclude;
        BackupCreateConfig config;

        @Generated
        BackupCreate(String id, String[] include, String[] exclude, BackupCreateConfig config) {
            this.id = id;
            this.include = include;
            this.exclude = exclude;
            this.config = config;
        }

        @Generated
        public static BackupCreateBuilder builder() {
            return new BackupCreateBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String[] getInclude() {
            return this.include;
        }

        @Generated
        public String[] getExclude() {
            return this.exclude;
        }

        @Generated
        public BackupCreateConfig getConfig() {
            return this.config;
        }

        @Generated
        public static class BackupCreateBuilder {
            @Generated
            private String id;
            @Generated
            private String[] include;
            @Generated
            private String[] exclude;
            @Generated
            private BackupCreateConfig config;

            @Generated
            BackupCreateBuilder() {
            }

            @Generated
            public BackupCreateBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public BackupCreateBuilder include(String[] include) {
                this.include = include;
                return this;
            }

            @Generated
            public BackupCreateBuilder exclude(String[] exclude) {
                this.exclude = exclude;
                return this;
            }

            @Generated
            public BackupCreateBuilder config(BackupCreateConfig config) {
                this.config = config;
                return this;
            }

            @Generated
            public BackupCreate build() {
                return new BackupCreate(this.id, this.include, this.exclude, this.config);
            }

            @Generated
            public String toString() {
                return "BackupCreator.BackupCreate.BackupCreateBuilder(id=" + this.id + ", include=" + Arrays.deepToString(this.include) + ", exclude=" + Arrays.deepToString(this.exclude) + ", config=" + this.config + ")";
            }
        }
    }
}

