/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.batch;

import io.weaviate.client.Config;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.util.BeaconPath;
import io.weaviate.client.base.util.DbVersionSupport;
import io.weaviate.client.base.util.GrpcVersionSupport;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.batch.api.ObjectsBatchDeleter;
import io.weaviate.client.v1.batch.api.ObjectsBatcher;
import io.weaviate.client.v1.batch.api.ReferencePayloadBuilder;
import io.weaviate.client.v1.batch.api.ReferencesBatcher;
import io.weaviate.client.v1.batch.util.ObjectsPath;
import io.weaviate.client.v1.batch.util.ReferencesPath;
import io.weaviate.client.v1.data.Data;

public class Batch {
    private final Config config;
    private final HttpClient httpClient;
    private final AccessTokenProvider tokenProvider;
    private final BeaconPath beaconPath;
    private final ObjectsPath objectsPath;
    private final ReferencesPath referencesPath;
    private final GrpcVersionSupport grpcVersionSupport;
    private final Data data;

    public Batch(HttpClient httpClient, Config config, DbVersionSupport dbVersionSupport, GrpcVersionSupport grpcVersionSupport, AccessTokenProvider tokenProvider, Data data) {
        this.config = config;
        this.httpClient = httpClient;
        this.tokenProvider = tokenProvider;
        this.beaconPath = new BeaconPath(dbVersionSupport);
        this.grpcVersionSupport = grpcVersionSupport;
        this.objectsPath = new ObjectsPath();
        this.referencesPath = new ReferencesPath();
        this.data = data;
    }

    public ObjectsBatcher objectsBatcher() {
        return this.objectsBatcher(ObjectsBatcher.BatchRetriesConfig.defaultConfig().build());
    }

    public ObjectsBatcher objectsBatcher(ObjectsBatcher.BatchRetriesConfig batchRetriesConfig) {
        return ObjectsBatcher.create(this.httpClient, this.config, this.data, this.objectsPath, this.tokenProvider, this.grpcVersionSupport, batchRetriesConfig);
    }

    public ObjectsBatcher objectsAutoBatcher() {
        return this.objectsAutoBatcher(ObjectsBatcher.BatchRetriesConfig.defaultConfig().build(), ObjectsBatcher.AutoBatchConfig.defaultConfig().build());
    }

    public ObjectsBatcher objectsAutoBatcher(ObjectsBatcher.BatchRetriesConfig batchRetriesConfig) {
        return this.objectsAutoBatcher(batchRetriesConfig, ObjectsBatcher.AutoBatchConfig.defaultConfig().build());
    }

    public ObjectsBatcher objectsAutoBatcher(ObjectsBatcher.AutoBatchConfig autoBatchConfig) {
        return this.objectsAutoBatcher(ObjectsBatcher.BatchRetriesConfig.defaultConfig().build(), autoBatchConfig);
    }

    public ObjectsBatcher objectsAutoBatcher(ObjectsBatcher.BatchRetriesConfig batchRetriesConfig, ObjectsBatcher.AutoBatchConfig autoBatchConfig) {
        return ObjectsBatcher.createAuto(this.httpClient, this.config, this.data, this.objectsPath, this.tokenProvider, this.grpcVersionSupport, batchRetriesConfig, autoBatchConfig);
    }

    public ObjectsBatchDeleter objectsBatchDeleter() {
        return new ObjectsBatchDeleter(this.httpClient, this.config, this.objectsPath);
    }

    public ReferencePayloadBuilder referencePayloadBuilder() {
        return new ReferencePayloadBuilder(this.beaconPath);
    }

    public ReferencesBatcher referencesBatcher() {
        return this.referencesBatcher(ReferencesBatcher.BatchRetriesConfig.defaultConfig().build());
    }

    public ReferencesBatcher referencesBatcher(ReferencesBatcher.BatchRetriesConfig batchRetriesConfig) {
        return ReferencesBatcher.create(this.httpClient, this.config, this.referencesPath, batchRetriesConfig);
    }

    public ReferencesBatcher referencesAutoBatcher() {
        return this.referencesAutoBatcher(ReferencesBatcher.BatchRetriesConfig.defaultConfig().build(), ReferencesBatcher.AutoBatchConfig.defaultConfig().build());
    }

    public ReferencesBatcher referencesAutoBatcher(ReferencesBatcher.BatchRetriesConfig batchRetriesConfig) {
        return this.referencesAutoBatcher(batchRetriesConfig, ReferencesBatcher.AutoBatchConfig.defaultConfig().build());
    }

    public ReferencesBatcher referencesAutoBatcher(ReferencesBatcher.AutoBatchConfig autoBatchConfig) {
        return this.referencesAutoBatcher(ReferencesBatcher.BatchRetriesConfig.defaultConfig().build(), autoBatchConfig);
    }

    public ReferencesBatcher referencesAutoBatcher(ReferencesBatcher.BatchRetriesConfig batchRetriesConfig, ReferencesBatcher.AutoBatchConfig autoBatchConfig) {
        return ReferencesBatcher.createAuto(this.httpClient, this.config, this.referencesPath, batchRetriesConfig, autoBatchConfig);
    }
}

