/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;

public class Targets {
    private final CombinationMethod combinationMethod;
    private final String[] targetVectors;
    private final Map<String, Float[]> weights;

    String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (this.combinationMethod != null) {
            arg.add(String.format("combinationMethod:%s", this.combinationMethod.name()));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        if (this.weights != null && !this.weights.isEmpty()) {
            LinkedHashSet<String> weightsArg = new LinkedHashSet<String>();
            for (Map.Entry<String, Float[]> e : this.weights.entrySet()) {
                Float[] weightsPerTarget = e.getValue();
                String target = e.getKey();
                String weight = Serializer.array(weightsPerTarget);
                if (weightsPerTarget.length == 1) {
                    weight = weightsPerTarget[0].toString();
                }
                weightsArg.add(String.format("%s:%s", target, weight));
            }
            arg.add(String.format("weights:{%s}", String.join((CharSequence)" ", weightsArg)));
        }
        return String.format("targets:{%s}", String.join((CharSequence)" ", arg));
    }

    @Generated
    Targets(CombinationMethod combinationMethod, String[] targetVectors, Map<String, Float[]> weights) {
        this.combinationMethod = combinationMethod;
        this.targetVectors = targetVectors;
        this.weights = weights;
    }

    @Generated
    public static TargetsBuilder builder() {
        return new TargetsBuilder();
    }

    @Generated
    public CombinationMethod getCombinationMethod() {
        return this.combinationMethod;
    }

    @Generated
    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    @Generated
    public Map<String, Float[]> getWeights() {
        return this.weights;
    }

    @Generated
    public String toString() {
        return "Targets(combinationMethod=" + (Object)((Object)this.getCombinationMethod()) + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ", weights=" + this.getWeights() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Targets)) {
            return false;
        }
        Targets other = (Targets)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CombinationMethod this$combinationMethod = this.getCombinationMethod();
        CombinationMethod other$combinationMethod = other.getCombinationMethod();
        if (this$combinationMethod == null ? other$combinationMethod != null : !((Object)((Object)this$combinationMethod)).equals((Object)other$combinationMethod)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors())) {
            return false;
        }
        Map<String, Float[]> this$weights = this.getWeights();
        Map<String, Float[]> other$weights = other.getWeights();
        return !(this$weights == null ? other$weights != null : !((Object)this$weights).equals(other$weights));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Targets;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CombinationMethod $combinationMethod = this.getCombinationMethod();
        result = result * 59 + ($combinationMethod == null ? 43 : ((Object)((Object)$combinationMethod)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        Map<String, Float[]> $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : ((Object)$weights).hashCode());
        return result;
    }

    public static enum CombinationMethod {
        minimum("minimum"),
        average("average"),
        sum("sum"),
        manualWeights("manualWeights"),
        relativeScore("relativeScore");

        private final String type;

        private CombinationMethod(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }

    public static class TargetsBuilder {
        @Generated
        private CombinationMethod combinationMethod;
        @Generated
        private String[] targetVectors;
        Map<String, Float[]> weights = new LinkedHashMap<String, Float[]>();

        public TargetsBuilder weights(Map<String, Float> weights) {
            this.weights.clear();
            for (Map.Entry<String, Float> e : weights.entrySet()) {
                this.weights.put(e.getKey(), new Float[]{e.getValue()});
            }
            return this;
        }

        public TargetsBuilder weightsMulti(Map<String, Float[]> weights) {
            this.weights = weights;
            return this;
        }

        @Generated
        TargetsBuilder() {
        }

        @Generated
        public TargetsBuilder combinationMethod(CombinationMethod combinationMethod) {
            this.combinationMethod = combinationMethod;
            return this;
        }

        @Generated
        public TargetsBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        @Generated
        public Targets build() {
            return new Targets(this.combinationMethod, this.targetVectors, this.weights);
        }

        @Generated
        public String toString() {
            return "Targets.TargetsBuilder(combinationMethod=" + (Object)((Object)this.combinationMethod) + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ", weights=" + this.weights + ")";
        }
    }
}

