/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.mysql.brave;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.ServerSpan;
import com.github.kristofa.brave.ServerSpanState;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.jooq.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import zipkin.Endpoint;
import zipkin.autoconfigure.storage.mysql.ZipkinMySQLStorageProperties;

@ConditionalOnBean(value={Brave.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="mysql")
@Configuration
public class TraceZipkinMySQLStorageAutoConfiguration
extends DefaultExecuteListener {
    @Autowired
    ZipkinMySQLStorageProperties mysql;
    @Autowired
    @Lazy
    Brave brave;
    @Autowired
    @Qualifier(value="mysql")
    Endpoint mysqlEndpoint;

    @Bean
    ExecuteListenerProvider tracingExecuteListenerProvider() {
        return new DefaultExecuteListenerProvider((ExecuteListener)this);
    }

    @Bean
    @ConditionalOnMissingBean(value={Executor.class})
    public Executor executor(ServerSpanState serverState) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("MySQLStorage-");
        executor.initialize();
        return command -> {
            ServerSpan currentSpan = serverState.getCurrentServerSpan();
            executor.execute(() -> {
                serverState.setCurrentServerSpan(currentSpan);
                command.run();
            });
        };
    }

    @Bean
    @Qualifier(value="mysql")
    Endpoint mysql() throws UnknownHostException {
        int ipv4 = ByteBuffer.wrap(InetAddress.getByName(this.mysql.getHost()).getAddress()).getInt();
        return Endpoint.create((String)"mysql", (int)ipv4, (int)this.mysql.getPort());
    }

    public void renderEnd(ExecuteContext ctx) {
        if (this.brave.serverSpanThreadBinder().getCurrentServerSpan() == null || this.brave.serverSpanThreadBinder().getCurrentServerSpan().getSpan() == null) {
            return;
        }
        this.brave.clientTracer().startNewSpan(ctx.type().toString().toLowerCase());
        Object[] batchSQL = ctx.batchSQL();
        if (!StringUtils.isBlank((String)ctx.sql())) {
            this.brave.clientTracer().submitBinaryAnnotation("jdbc.query", ctx.sql());
        } else if (batchSQL.length > 0 && batchSQL[batchSQL.length - 1] != null) {
            this.brave.clientTracer().submitBinaryAnnotation("jdbc.query", StringUtils.join((Object[])batchSQL, (char)'\n'));
        }
        this.brave.clientTracer().setClientSent(this.mysqlEndpoint.ipv4, (int)this.mysqlEndpoint.port.shortValue(), this.mysqlEndpoint.serviceName);
    }

    public void executeEnd(ExecuteContext ctx) {
        if (this.brave.serverSpanThreadBinder().getCurrentServerSpan() == null || this.brave.serverSpanThreadBinder().getCurrentServerSpan().getSpan() == null) {
            return;
        }
        this.brave.clientTracer().setClientReceived();
    }
}

