/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.cosid;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import me.ahoo.cosid.cosid.CosIdGenerator;
import me.ahoo.cosid.cosid.CosIdIdStateParser;
import me.ahoo.cosid.cosid.CosIdState;
import me.ahoo.cosid.snowflake.exception.ClockBackwardsException;
import me.ahoo.cosid.snowflake.exception.TimestampOverflowException;

@Beta
public class RadixCosIdGenerator
implements CosIdGenerator {
    public static final int DEFAULT_TIMESTAMP_BIT = 44;
    public static final int DEFAULT_MACHINE_BIT = 20;
    public static final int DEFAULT_SEQUENCE_BIT = 16;
    public static final int DEFAULT_SEQUENCE_RESET_THRESHOLD = Short.MAX_VALUE;
    private final long maxTimestamp;
    private final int maxMachine;
    private final int maxSequence;
    private final int sequenceResetThreshold;
    private final int machineId;
    private int sequence = 0;
    private long lastTimestamp = -1L;
    private final CosIdIdStateParser stateParser;

    public RadixCosIdGenerator(int timestampBit, int machineIdBit, int sequenceBit, int machineId, int sequenceResetThreshold, CosIdIdStateParser stateParser) {
        this.maxTimestamp = -1L << timestampBit ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxMachine = ~(-1 << machineIdBit);
        this.maxSequence = ~(-1 << sequenceBit);
        this.sequenceResetThreshold = sequenceResetThreshold;
        if (machineId > this.maxMachine || machineId < 0) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"machineId can't be greater than maxMachine[%s] or less than 0 .", (Object[])new Object[]{this.maxMachine}));
        }
        this.machineId = machineId;
        this.stateParser = stateParser;
    }

    @Override
    public int getMachineId() {
        return this.machineId;
    }

    @Override
    public long getLastTimestamp() {
        return this.lastTimestamp;
    }

    @Override
    public CosIdIdStateParser getStateParser() {
        return this.stateParser;
    }

    private long nextTime() {
        long time = System.currentTimeMillis();
        while (time <= this.lastTimestamp) {
            time = System.currentTimeMillis();
        }
        return time;
    }

    @Override
    public synchronized CosIdState generateAsState() {
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp < this.lastTimestamp) {
            throw new ClockBackwardsException(this.lastTimestamp, currentTimestamp);
        }
        if (currentTimestamp > this.lastTimestamp && this.sequence >= this.sequenceResetThreshold) {
            this.sequence = 0;
        }
        this.sequence = this.sequence + 1 & this.maxSequence;
        if (this.sequence == 0) {
            currentTimestamp = this.nextTime();
        }
        if (currentTimestamp > this.maxTimestamp) {
            throw new TimestampOverflowException(0L, currentTimestamp, this.maxTimestamp);
        }
        this.lastTimestamp = currentTimestamp;
        return new CosIdState(this.lastTimestamp, this.machineId, this.sequence);
    }

    @Override
    public String generateAsString() {
        CosIdState state = this.generateAsState();
        return this.stateParser.asString(state);
    }
}

