/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Modifier;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Visitor;

public class DeclarationStatement
extends Statement {
    public final int modifiers;
    public final ParameterExpression parameter;
    public final Expression initializer;

    public DeclarationStatement(int modifiers, ParameterExpression parameter, Expression initializer) {
        super(ExpressionType.Declaration, Void.TYPE);
        assert (parameter != null) : "parameter should not be null";
        this.modifiers = modifiers;
        this.parameter = parameter;
        this.initializer = initializer;
    }

    public DeclarationStatement accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        Expression initializer = this.initializer != null ? this.initializer.accept(visitor) : null;
        return visitor.visit(this, initializer);
    }

    void accept0(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(modifiers).append(' ');
        }
        writer.append(this.parameter.type).append(' ').append(this.parameter.name);
        if (this.initializer != null) {
            writer.append(" = ").append(this.initializer);
        }
        writer.append(';');
        writer.newlineAndIndent();
    }

    public void accept2(ExpressionWriter writer, boolean withType) {
        if (withType) {
            String modifiers = Modifier.toString(this.modifiers);
            if (!modifiers.isEmpty()) {
                writer.append(modifiers).append(' ');
            }
            writer.append(this.parameter.type).append(' ');
        } else {
            writer.append(", ");
        }
        writer.append(this.parameter.name);
        if (this.initializer != null) {
            writer.append(" = ").append(this.initializer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeclarationStatement that = (DeclarationStatement)o;
        if (this.modifiers != that.modifiers) {
            return false;
        }
        if (this.initializer != null ? !this.initializer.equals(that.initializer) : that.initializer != null) {
            return false;
        }
        return this.parameter.equals(that.parameter);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.modifiers;
        result = 31 * result + this.parameter.hashCode();
        result = 31 * result + (this.initializer != null ? this.initializer.hashCode() : 0);
        return result;
    }
}

