/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.crf;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.ansj.app.crf.Config;
import org.ansj.app.crf.pojo.Element;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakeTrainFile {
    public static final Logger logger = LoggerFactory.getLogger(MakeTrainFile.class);

    public static void main(String[] args) {
        String inputPath = "corpus.txt";
        String outputPath = "train.txt";
        if (args != null && args.length == 2) {
            inputPath = args[0];
            outputPath = args[1];
        }
        if (StringUtil.isBlank((CharSequence)inputPath) || StringUtil.isBlank((CharSequence)outputPath)) {
            logger.info("org.ansj.app.crf.MakeTrainFile [inputPath] [outputPath]");
            return;
        }
        try {
            BufferedReader reader = IOUtil.getReader((String)inputPath, (String)"utf-8");
            Throwable throwable = null;
            try {
                FileOutputStream fos = new FileOutputStream(outputPath);
                Throwable throwable2 = null;
                try {
                    String temp = null;
                    int i = 0;
                    while ((temp = reader.readLine()) != null) {
                        StringBuilder sb = new StringBuilder("\n");
                        if (StringUtil.isBlank((CharSequence)temp)) continue;
                        if (i == 0) {
                            temp = StringUtil.trim((String)temp);
                        }
                        List<Element> list = Config.makeToElementList(temp, "\\s+");
                        for (Element element : list) {
                            sb.append(element.nameStr() + " " + Config.getTagName(element.getTag()));
                            sb.append("\n");
                        }
                        fos.write(sb.toString().getBytes("utf-8"));
                        System.out.println(++i);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fos != null) {
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable4) {
                            }
                        } else {
                            fos.close();
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable6) {
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.warn("\u6587\u4ef6\u6ca1\u6709\u627e\u5230", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("IO\u5f02\u5e38", (Throwable)e);
        }
    }
}

