/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.app.crf;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.ansj.app.crf.Config;
import org.ansj.app.crf.model.CRFModel;
import org.ansj.app.crf.model.CRFppTxtModel;
import org.ansj.app.crf.model.WapitiCRFModel;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.MapCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Model {
    public final Logger logger = LoggerFactory.getLogger((String)"CRF");
    protected String name;
    protected Config config;
    protected SmartForest<float[]> featureTree = null;
    protected float[][] status = new float[4][4];
    public int allFeatureCount = 0;

    public Model(String name) {
        this.name = name;
    }

    public abstract boolean checkModel(String var1) throws IOException;

    public static Model load(String name, String modelPath) throws Exception {
        Model model = new CRFModel(name);
        if (model.checkModel(modelPath)) {
            model.loadModel(modelPath);
            return model;
        }
        model = new CRFppTxtModel(name);
        if (model.checkModel(modelPath)) {
            model.loadModel(modelPath);
            return model;
        }
        model = new WapitiCRFModel(name);
        if (model.checkModel(modelPath)) {
            model.loadModel(modelPath);
            return model;
        }
        throw new Exception("I did not know what type of model by file " + modelPath);
    }

    public abstract void loadModel(String var1) throws Exception;

    public float[] getFeature(char ... chars) {
        if (chars == null) {
            return null;
        }
        SmartForest sf = this.featureTree;
        if ((sf = sf.getBranch(chars)) == null || sf.getParam() == null) {
            return null;
        }
        return (float[])sf.getParam();
    }

    public String getName() {
        return this.name;
    }

    public Config getConfig() {
        return this.config;
    }

    public float tagRate(int s1, int s2) {
        return this.status[s1][s2];
    }

    protected static void printFeatureTree(String cs, float[] tempW) {
        String name = "*";
        if (tempW.length == 4) {
            name = "U";
        }
        name = name + "*" + (cs.charAt(cs.length() - 1) - 150 + 1) + ":" + cs.substring(0, cs.length() - 1);
        for (int i = 0; i < tempW.length; ++i) {
            if (tempW[i] == 0.0f) continue;
            System.out.println(name + "\t" + Config.getTagName(i / 4 - 1) + "\t" + Config.getTagName(i % 4) + "\t" + tempW[i]);
        }
    }

    public void writeModel(String path) {
        try {
            FileOutputStream fso = new FileOutputStream(path);
            Throwable throwable = null;
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(fso));
                oos.writeUTF("ansj1");
                oos.writeObject(this.status);
                oos.writeObject(this.config.getTemplate());
                Map map = this.featureTree.toMap();
                MapCount mc = new MapCount();
                for (float[] fArray : map.values()) {
                    mc.add((Object)fArray.length);
                }
                for (Map.Entry entry : mc.get().entrySet()) {
                    int win = (Integer)entry.getKey();
                    oos.writeInt(win);
                    oos.writeInt(((Double)entry.getValue()).intValue());
                    for (Map.Entry e : map.entrySet()) {
                        if (((float[])e.getValue()).length != win) continue;
                        oos.writeUTF((String)e.getKey());
                        float[] value = (float[])e.getValue();
                        for (int i = 0; i < win; ++i) {
                            oos.writeFloat(value[i]);
                        }
                    }
                }
                oos.writeInt(0);
                oos.writeInt(0);
                oos.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fso != null) {
                    if (throwable != null) {
                        try {
                            fso.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        fso.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            this.logger.warn("\u6587\u4ef6\u6ca1\u6709\u627e\u5230", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.warn("IO\u5f02\u5e38", (Throwable)e);
        }
    }
}

