/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.domain;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.ansj.domain.AnsjItem;
import org.ansj.domain.Nature;
import org.ansj.domain.TermNature;
import org.ansj.domain.TermNatures;
import org.ansj.util.MathUtil;
import org.nlpcn.commons.lang.util.StringUtil;

public class Term
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String realName;
    private int offe;
    private TermNatures termNatures = TermNatures.NULL;
    private AnsjItem item = AnsjItem.NULL;
    private Term next;
    private double score = 0.0;
    private double selfScore = 1.0;
    private Term from;
    private Term to;
    private Nature nature = Nature.NULL;
    private boolean newWord;
    private List<Term> subTerm = null;

    public Term(String name, int offe, AnsjItem item) {
        this.name = name;
        this.offe = offe;
        this.item = item;
        if (item.termNatures != null) {
            this.termNatures = item.termNatures;
            if (this.termNatures.nature != null) {
                this.nature = this.termNatures.nature;
            }
        }
    }

    public Term(String name, int offe, TermNatures termNatures) {
        this.name = name;
        this.offe = offe;
        this.termNatures = termNatures;
        if (termNatures.nature != null) {
            this.nature = termNatures.nature;
        }
    }

    public Term(String name, int offe, String natureStr, int natureFreq) {
        this.name = name;
        this.offe = offe;
        TermNature termNature = new TermNature(natureStr, natureFreq);
        this.nature = termNature.nature;
        this.termNatures = new TermNatures(termNature);
    }

    public int toValue() {
        return this.offe + this.name.length();
    }

    public int getOffe() {
        return this.offe;
    }

    public void setOffe(int offe) {
        this.offe = offe;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPathScore(Term from, Map<String, Double> relationMap) {
        double score = MathUtil.compuScore(from, this, relationMap);
        if (this.from == null || this.score == 0.0 || this.score >= score) {
            this.setFromAndScore(from, score);
        }
    }

    public void setPathSelfScore(Term from) {
        double score = this.selfScore + from.score;
        if (this.from == null || this.score > score) {
            this.setFromAndScore(from, score);
        }
    }

    private void setFromAndScore(Term from, double score) {
        this.from = from;
        this.score = score;
    }

    public Term merage(Term to) {
        this.name = this.name + to.getName();
        if (StringUtil.isNotBlank((CharSequence)this.realName) && StringUtil.isNotBlank((CharSequence)to.getRealName())) {
            this.realName = this.realName + to.getRealName();
        }
        this.setTo(to.to);
        return this;
    }

    public void updateOffe(int offe) {
        this.offe += offe;
    }

    public Term next() {
        return this.next;
    }

    public Term setNext(Term next) {
        this.next = next;
        return this;
    }

    public Term from() {
        return this.from;
    }

    public Term to() {
        return this.to;
    }

    public void setFrom(Term from) {
        this.from = from;
    }

    public void setTo(Term to) {
        this.to = to;
    }

    public TermNatures termNatures() {
        return this.termNatures;
    }

    public void setNature(Nature nature) {
        this.nature = nature;
    }

    public Nature natrue() {
        return this.nature;
    }

    public String getNatureStr() {
        return this.nature.natureStr;
    }

    public String toString() {
        if ("null".equals(this.nature.natureStr)) {
            return this.getRealName();
        }
        return this.getRealName() + "/" + this.nature.natureStr;
    }

    public void clearScore() {
        this.score = 0.0;
        this.selfScore = 0.0;
    }

    public void setSubTerm(List<Term> subTerm) {
        this.subTerm = subTerm;
    }

    public List<Term> getSubTerm() {
        return this.subTerm;
    }

    public String getRealName() {
        if (this.realName == null) {
            return this.name;
        }
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public double score() {
        return this.score;
    }

    public void score(double score) {
        this.score = score;
    }

    public double selfScore() {
        return this.selfScore;
    }

    public void selfScore(double selfScore) {
        this.selfScore = selfScore;
    }

    public AnsjItem item() {
        return this.item;
    }

    public boolean isNewWord() {
        return this.newWord;
    }

    public void setNewWord(boolean newWord) {
        this.newWord = newWord;
    }

    public void updateTermNaturesAndNature(TermNatures termNatures) {
        this.termNatures = termNatures;
        this.nature = termNatures.nature;
    }
}

