/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.ansj.library.DATDictionary;
import org.ansj.util.MyStaticValue;
import org.nlpcn.commons.lang.tire.domain.Forest;
import org.nlpcn.commons.lang.tire.domain.Value;
import org.nlpcn.commons.lang.tire.library.Library;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;

public class UserDefineLibrary {
    public static final String DEFAULT_NATURE = "userDefine";
    public static final Integer DEFAULT_FREQ = 1000;
    public static final String DEFAULT_FREQ_STR = "1000";
    public static Forest FOREST = null;
    public static Forest ambiguityForest = null;
    public static Forest synonymsForest = null;

    public static void insertWord(String keyword, String nature, int freq) {
        if (FOREST == null) {
            FOREST = new Forest();
        }
        String[] paramers = new String[]{nature, String.valueOf(freq)};
        Value value = new Value(keyword, paramers);
        Library.insertWord((Forest)FOREST, (Value)value);
    }

    public static void insertWord(String keyword) {
        UserDefineLibrary.insertWord(keyword, DEFAULT_NATURE, DEFAULT_FREQ);
    }

    private static void initAmbiguityLibrary() {
        File[] lib = UserDefineLibrary.findLibrary(MyStaticValue.ambiguityLibrary);
        if (lib.length > 0) {
            ambiguityForest = new Forest();
            for (File file : lib) {
                try {
                    BufferedReader br = IOUtil.getReader((File)file, (String)"utf-8");
                    Throwable throwable = null;
                    try {
                        String temp;
                        while ((temp = br.readLine()) != null) {
                            if (!StringUtil.isNotBlank((CharSequence)temp)) continue;
                            temp = StringUtil.trim((String)temp);
                            String[] split = temp.split("\t");
                            StringBuilder sb = new StringBuilder();
                            if (split.length % 2 != 0) {
                                MyStaticValue.LIBRARYLOG.error("init ambiguity  error in line :" + temp + " format err !");
                            }
                            for (int i = 0; i < split.length; i += 2) {
                                sb.append(split[i]);
                            }
                            ambiguityForest.addBranch(sb.toString(), (Object)split);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br != null) {
                            if (throwable != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable3) {
                                }
                            } else {
                                br.close();
                            }
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    MyStaticValue.LIBRARYLOG.warn("\u4e0d\u652f\u6301\u7684\u7f16\u7801", (Throwable)e);
                }
                catch (IOException e) {
                    MyStaticValue.LIBRARYLOG.warn("Init ambiguity library error :{}, path: {}", (Object)e.getMessage(), (Object)file.getPath());
                }
            }
            MyStaticValue.LIBRARYLOG.info("Init ambiguity library ok!");
        } else {
            MyStaticValue.LIBRARYLOG.warn("Init ambiguity library warning :{} because : file not found or failed to read !", (Object)MyStaticValue.ambiguityLibrary);
        }
    }

    private static void initSynonymsLibrary() {
        File[] lib = UserDefineLibrary.findLibrary(MyStaticValue.synonymsLibrary);
        if (lib.length > 0) {
            synonymsForest = new Forest();
            for (File file : lib) {
                try {
                    BufferedReader br = IOUtil.getReader((File)file, (String)"utf-8");
                    Throwable throwable = null;
                    try {
                        String temp;
                        while ((temp = br.readLine()) != null) {
                            if (!StringUtil.isNotBlank((CharSequence)temp)) continue;
                            temp = StringUtil.trim((String)temp);
                            String[] split = temp.split("\t");
                            MyStaticValue.LIBRARYLOG.info("init synonyms in line :" + temp);
                            synonymsForest.addBranch(split[0], (Object)split);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br != null) {
                            if (throwable != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable3) {
                                }
                            } else {
                                br.close();
                            }
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    MyStaticValue.LIBRARYLOG.warn("\u4e0d\u652f\u6301\u7684\u7f16\u7801", (Throwable)e);
                }
                catch (IOException e) {
                    MyStaticValue.LIBRARYLOG.warn("Init synonyms library error :{}, path: {}", (Object)e.getMessage(), (Object)file.getPath());
                }
            }
            MyStaticValue.LIBRARYLOG.info("Init synonyms library ok!");
        } else {
            MyStaticValue.LIBRARYLOG.warn("Init synonyms library warning :{} because : file not found or failed to read !", (Object)MyStaticValue.synonymsLibrary);
        }
    }

    private static void initUserLibrary() {
        FOREST = MyStaticValue.getDicForest();
    }

    public static void loadLibrary(Forest forest, String path) {
        File[] lib = UserDefineLibrary.findLibrary(path);
        if (lib.length > 0) {
            for (File file : lib) {
                try {
                    BufferedReader br = IOUtil.getReader((InputStream)new FileInputStream(file), (String)"UTF-8");
                    Throwable throwable = null;
                    try {
                        String temp;
                        while ((temp = br.readLine()) != null) {
                            if (!StringUtil.isNotBlank((CharSequence)temp)) continue;
                            temp = StringUtil.trim((String)temp);
                            String[] strs = temp.split("\t");
                            strs[0] = strs[0].toLowerCase();
                            if (MyStaticValue.isSkipUserDefine && DATDictionary.getId(strs[0]) > 0) continue;
                            Value value = strs.length != 3 ? new Value(strs[0], new String[]{DEFAULT_NATURE, DEFAULT_FREQ_STR}) : new Value(strs[0], new String[]{strs[1], strs[2]});
                            Library.insertWord((Forest)forest, (Value)value);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (br != null) {
                            if (throwable != null) {
                                try {
                                    br.close();
                                }
                                catch (Throwable throwable3) {
                                }
                            } else {
                                br.close();
                            }
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    MyStaticValue.LIBRARYLOG.warn("\u4e0d\u652f\u6301\u7684\u7f16\u7801", (Throwable)e);
                }
                catch (IOException e) {
                    MyStaticValue.LIBRARYLOG.warn("Init user library error :{}, path: {}", (Object)e.getMessage(), (Object)file.getPath());
                }
            }
            MyStaticValue.LIBRARYLOG.info("Init user library ok!");
        } else {
            MyStaticValue.LIBRARYLOG.warn("Init user library  error :{} because : not find that file !", (Object)path);
        }
    }

    public static void removeWord(String word) {
        Library.removeWord((Forest)FOREST, (String)word);
    }

    public static String[] getParams(String word) {
        return UserDefineLibrary.getParams(FOREST, word);
    }

    public static String[] getParams(Forest forest, String word) {
        Forest temp = forest;
        for (int i = 0; i < word.length(); ++i) {
            if ((temp = temp.get(word.charAt(i))) != null) continue;
            return null;
        }
        if (temp.getStatus() > 1) {
            return (String[])temp.getParam();
        }
        return null;
    }

    public static boolean contains(String word) {
        return UserDefineLibrary.getParams(word) != null;
    }

    public static void clear() {
        FOREST.clear();
    }

    private static File[] findLibrary(String path) {
        URL url;
        File[] libs = new File[]{};
        File file = new File(path);
        if (!file.exists() && (url = UserDefineLibrary.class.getClassLoader().getResource(path)) != null) {
            file = new File(url.getPath());
        }
        if (file.canRead()) {
            File[] files;
            if (file.isFile()) {
                libs = new File[]{file};
            } else if (file.isDirectory() && (files = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".dic") && dir.canRead();
                }
            })) != null && files.length > 0) {
                libs = files;
            }
        }
        return libs;
    }

    static {
        UserDefineLibrary.initUserLibrary();
        UserDefineLibrary.initAmbiguityLibrary();
        UserDefineLibrary.initSynonymsLibrary();
    }
}

