/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.library.name;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ansj.domain.PersonNatureAttr;
import org.ansj.util.MyStaticValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonAttrLibrary {
    public static final Logger logger = LoggerFactory.getLogger(PersonAttrLibrary.class);
    private HashMap<String, PersonNatureAttr> pnMap = null;

    public HashMap<String, PersonNatureAttr> getPersonMap() {
        if (this.pnMap != null) {
            return this.pnMap;
        }
        this.init1();
        this.init2();
        return this.pnMap;
    }

    private void init2() {
        Map<String, int[][]> personFreqMap = MyStaticValue.getPersonFreqMap();
        Set<Map.Entry<String, int[][]>> entrySet = personFreqMap.entrySet();
        PersonNatureAttr pna = null;
        for (Map.Entry<String, int[][]> entry : entrySet) {
            pna = this.pnMap.get(entry.getKey());
            if (pna == null) {
                pna = new PersonNatureAttr();
                pna.setlocFreq(entry.getValue());
                this.pnMap.put(entry.getKey(), pna);
                continue;
            }
            pna.setlocFreq(entry.getValue());
        }
    }

    private void init1() {
        try {
            BufferedReader br = MyStaticValue.getPersonReader();
            Throwable throwable = null;
            try {
                this.pnMap = new HashMap();
                String temp = null;
                String[] strs = null;
                PersonNatureAttr pna = null;
                while ((temp = br.readLine()) != null) {
                    pna = new PersonNatureAttr();
                    strs = temp.split("\t");
                    pna = this.pnMap.get(strs[0]);
                    if (pna == null) {
                        pna = new PersonNatureAttr();
                    }
                    pna.addFreq(Integer.parseInt(strs[1]), Integer.parseInt(strs[2]));
                    this.pnMap.put(strs[0], pna);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (br != null) {
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        br.close();
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warn("\u6570\u5b57\u683c\u5f0f\u4e0d\u6b63\u786e", (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("IO\u5f02\u5e38", (Throwable)e);
        }
    }
}

