/*
 * Decompiled with CFR 0.152.
 */
package org.ansj.splitWord.analysis;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import org.ansj.domain.Result;
import org.ansj.domain.Term;
import org.ansj.library.UserDefineLibrary;
import org.ansj.recognition.arrimpl.AsianPersonRecognition;
import org.ansj.recognition.arrimpl.ForeignPersonRecognition;
import org.ansj.recognition.arrimpl.NumRecognition;
import org.ansj.recognition.arrimpl.UserDefineRecognition;
import org.ansj.splitWord.Analysis;
import org.ansj.util.AnsjReader;
import org.ansj.util.Graph;
import org.ansj.util.MyStaticValue;
import org.ansj.util.NameFix;
import org.ansj.util.TermUtil;
import org.nlpcn.commons.lang.tire.domain.Forest;

public class DicAnalysis
extends Analysis {
    @Override
    protected List<Term> getResult(final Graph graph) {
        Analysis.Merger merger = new Analysis.Merger(){

            @Override
            public List<Term> merger() {
                this.userDefineRecognition(graph, DicAnalysis.this.forests);
                graph.walkPath();
                this.userDefineRecognition(graph, DicAnalysis.this.forests);
                if (MyStaticValue.isNumRecognition.booleanValue() && graph.hasNum) {
                    new NumRecognition().recognition(graph.terms);
                }
                if (graph.hasPerson && MyStaticValue.isNameRecognition.booleanValue()) {
                    new AsianPersonRecognition().recognition(graph.terms);
                    graph.walkPathByScore();
                    NameFix.nameAmbiguity(graph.terms);
                    new ForeignPersonRecognition().recognition(graph.terms);
                    graph.walkPathByScore();
                }
                return this.getResult();
            }

            private void userDefineRecognition(Graph graph2, Forest ... forests) {
                new UserDefineRecognition(TermUtil.InsertTermType.REPLACE, forests).recognition(graph2.terms);
                graph2.rmLittlePath();
                graph2.walkPathByScore();
                graph2.rmLittlePath();
            }

            private List<Term> getResult() {
                ArrayList<Term> result = new ArrayList<Term>();
                int length = graph.terms.length - 1;
                for (int i = 0; i < length; ++i) {
                    if (graph.terms[i] == null) continue;
                    result.add(graph.terms[i]);
                }
                DicAnalysis.this.setRealName(graph, result);
                return result;
            }
        };
        return merger.merger();
    }

    public DicAnalysis(Forest ... forests) {
        if (forests == null) {
            forests = new Forest[]{UserDefineLibrary.FOREST};
        }
        this.forests = forests;
    }

    public DicAnalysis(BufferedReader reader, Forest ... forests) {
        this.forests = forests;
        super.resetContent(new AnsjReader(reader));
    }

    public static Result parse(String str) {
        return new DicAnalysis(new Forest[0]).parseStr(str);
    }

    public static Result parse(String str, Forest ... forests) {
        return new DicAnalysis(forests).parseStr(str);
    }
}

