/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.rest;

import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.metadata.annotation.processing.ClassPathMetadataStorage;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;

public class ServiceRestMetadataStorage {
    private final ClassPathMetadataStorage storage;

    public ServiceRestMetadataStorage(ProcessingEnvironment processingEnv) {
        this.storage = new ClassPathMetadataStorage(processingEnv);
    }

    public void append(Set<ServiceRestMetadata> serviceRestMetadata) throws IOException {
        this.storage.read("META-INF/dubbo/service-rest-metadata.json", reader -> {
            try {
                int len;
                StringBuilder stringBuilder = new StringBuilder();
                char[] buf = new char[1024];
                while ((len = reader.read(buf)) != -1) {
                    stringBuilder.append(buf, 0, len);
                }
                return JsonUtils.getJson().toJavaList(stringBuilder.toString(), ServiceRestMetadata.class);
            }
            catch (IOException e) {
                return null;
            }
        }).ifPresent(serviceRestMetadata::addAll);
        this.write(serviceRestMetadata);
    }

    public void write(Set<ServiceRestMetadata> serviceRestMetadata) throws IOException {
        if (serviceRestMetadata.isEmpty()) {
            return;
        }
        this.storage.write(() -> JsonUtils.getJson().toJson((Object)serviceRestMetadata), "META-INF/dubbo/service-rest-metadata.json");
    }
}

