/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.rest.springmvc;

import java.lang.reflect.Array;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.apache.dubbo.common.function.Streams;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.annotation.processing.rest.AbstractServiceRestMetadataResolver;
import org.apache.dubbo.metadata.annotation.processing.util.AnnotationUtils;

public class SpringMvcServiceRestMetadataResolver
extends AbstractServiceRestMetadataResolver {
    private static final int FIRST_ELEMENT_INDEX = 0;

    @Override
    public boolean supports(ProcessingEnvironment processingEnvironment, TypeElement serviceType) {
        return SpringMvcServiceRestMetadataResolver.supports(serviceType);
    }

    @Override
    protected boolean supports(ProcessingEnvironment processingEnv, TypeElement serviceType, TypeElement serviceInterfaceType, ExecutableElement method) {
        return AnnotationUtils.isAnnotationPresent(method, "org.springframework.web.bind.annotation.RequestMapping");
    }

    public static boolean supports(TypeElement serviceType) {
        return AnnotationUtils.isAnnotationPresent(serviceType, "org.springframework.stereotype.Controller");
    }

    @Override
    protected String resolveRequestPath(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method) {
        String requestPathFromType = this.getRequestPath(serviceType);
        String requestPathFromMethod = this.getRequestPath(method);
        return PathUtils.buildPath((String)requestPathFromType, (String[])new String[]{requestPathFromMethod});
    }

    @Override
    protected String resolveRequestMethod(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method) {
        AnnotationMirror requestMapping = this.getRequestMapping(method);
        Object httpMethod = AnnotationUtils.getAttribute(requestMapping, "method");
        if (httpMethod == null || Array.getLength(httpMethod) < 1) {
            return null;
        }
        return String.valueOf(Array.get(httpMethod, 0));
    }

    private AnnotationMirror getRequestMapping(Element element) {
        AnnotationMirror requestMapping = AnnotationUtils.findAnnotation(element, (CharSequence)"org.springframework.web.bind.annotation.RequestMapping");
        if (requestMapping == null) {
            requestMapping = AnnotationUtils.findMetaAnnotation(element, "org.springframework.web.bind.annotation.RequestMapping");
        }
        return requestMapping;
    }

    @Override
    protected void processProduces(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method, Set<String> produces) {
        this.addMediaTypes(method, "produces", produces);
    }

    @Override
    protected void processConsumes(ProcessingEnvironment processingEnv, TypeElement serviceType, ExecutableElement method, Set<String> consumes) {
        this.addMediaTypes(method, "consumes", consumes);
    }

    private void addMediaTypes(ExecutableElement method, String annotationAttributeName, Set<String> mediaTypesSet) {
        AnnotationMirror mappingAnnotation = this.getMappingAnnotation(method);
        Object[] mediaTypes = (String[])AnnotationUtils.getAttribute(mappingAnnotation, annotationAttributeName);
        if (ArrayUtils.isNotEmpty((Object[])mediaTypes)) {
            Stream.of(mediaTypes).forEach(mediaTypesSet::add);
        }
    }

    private AnnotationMirror getMappingAnnotation(Element element) {
        return SpringMvcServiceRestMetadataResolver.computeIfAbsent(String.valueOf(element), key -> (AnnotationMirror)Streams.filterFirst(AnnotationUtils.getAllAnnotations(element), (Predicate[])new Predicate[]{annotation -> {
            DeclaredType annotationType = annotation.getAnnotationType();
            if ("org.springframework.web.bind.annotation.RequestMapping".equals(annotationType.toString())) {
                return true;
            }
            return AnnotationUtils.isAnnotationPresent(annotationType.asElement(), "org.springframework.web.bind.annotation.RequestMapping");
        }}));
    }

    private String getRequestPath(Element element) {
        AnnotationMirror mappingAnnotation = this.getMappingAnnotation(element);
        return this.getRequestPath(mappingAnnotation);
    }

    private String getRequestPath(AnnotationMirror mappingAnnotation) {
        Object[] value = (String[])AnnotationUtils.getAttribute(mappingAnnotation, "value");
        if (ArrayUtils.isEmpty((Object[])value)) {
            value = (String[])AnnotationUtils.getAttribute(mappingAnnotation, "path");
        }
        if (ArrayUtils.isEmpty((Object[])value)) {
            return "";
        }
        return value[0];
    }
}

