/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.redis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.rpc.RpcException;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisMetadataReport
extends AbstractMetadataReport {
    private static final String REDIS_DATABASE_KEY = "database";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RedisMetadataReport.class);
    protected JedisPool pool;
    private Set<HostAndPort> jedisClusterNodes;
    private int timeout;
    private String password;

    public RedisMetadataReport(URL url) {
        super(url);
        this.timeout = url.getParameter("timeout", 1000);
        if (url.getParameter("cluster", false)) {
            this.jedisClusterNodes = new HashSet<HostAndPort>();
            List urls = url.getBackupUrls();
            for (URL tmpUrl : urls) {
                this.jedisClusterNodes.add(new HostAndPort(tmpUrl.getHost(), tmpUrl.getPort()));
            }
        } else {
            int database = url.getParameter(REDIS_DATABASE_KEY, 0);
            this.pool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), url.getHost(), url.getPort(), this.timeout, url.getPassword(), database);
        }
    }

    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata((BaseMetadataIdentifier)providerMetadataIdentifier, serviceDefinitions);
    }

    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata((BaseMetadataIdentifier)consumerMetadataIdentifier, value);
    }

    protected void doSaveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier, URL url) {
        this.storeMetadata((BaseMetadataIdentifier)serviceMetadataIdentifier, URL.encode((String)url.toFullString()));
    }

    protected void doRemoveMetadata(ServiceMetadataIdentifier serviceMetadataIdentifier) {
        this.deleteMetadata((BaseMetadataIdentifier)serviceMetadataIdentifier);
    }

    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.getMetadata((BaseMetadataIdentifier)metadataIdentifier);
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode((String)content)));
    }

    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urlListStr) {
        this.storeMetadata((BaseMetadataIdentifier)subscriberMetadataIdentifier, urlListStr);
    }

    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.getMetadata((BaseMetadataIdentifier)subscriberMetadataIdentifier);
    }

    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.getMetadata((BaseMetadataIdentifier)metadataIdentifier);
    }

    private void storeMetadata(BaseMetadataIdentifier metadataIdentifier, String v) {
        if (this.pool != null) {
            this.storeMetadataStandalone(metadataIdentifier, v);
        } else {
            this.storeMetadataInCluster(metadataIdentifier, v);
        }
    }

    private void storeMetadataInCluster(BaseMetadataIdentifier metadataIdentifier, String v) {
        try (JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());){
            jedisCluster.set(metadataIdentifier.getIdentifierKey() + ".metaData", v);
        }
        catch (Throwable e) {
            String msg = "Failed to put " + metadataIdentifier + " to redis cluster " + v + ", cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    private void storeMetadataStandalone(BaseMetadataIdentifier metadataIdentifier, String v) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.set(metadataIdentifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY), v);
        }
        catch (Throwable e) {
            String msg = "Failed to put " + metadataIdentifier + " to redis " + v + ", cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    private void deleteMetadata(BaseMetadataIdentifier metadataIdentifier) {
        if (this.pool != null) {
            this.deleteMetadataStandalone(metadataIdentifier);
        } else {
            this.deleteMetadataInCluster(metadataIdentifier);
        }
    }

    private void deleteMetadataInCluster(BaseMetadataIdentifier metadataIdentifier) {
        try (JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());){
            jedisCluster.del(metadataIdentifier.getIdentifierKey() + ".metaData");
        }
        catch (Throwable e) {
            String msg = "Failed to delete " + metadataIdentifier + " from redis cluster , cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    private void deleteMetadataStandalone(BaseMetadataIdentifier metadataIdentifier) {
        try (Jedis jedis = this.pool.getResource();){
            jedis.del(metadataIdentifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY));
        }
        catch (Throwable e) {
            String msg = "Failed to delete " + metadataIdentifier + " from redis , cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    private String getMetadata(BaseMetadataIdentifier metadataIdentifier) {
        if (this.pool != null) {
            return this.getMetadataStandalone(metadataIdentifier);
        }
        return this.getMetadataInCluster(metadataIdentifier);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMetadataInCluster(BaseMetadataIdentifier metadataIdentifier) {
        try (JedisCluster jedisCluster = new JedisCluster(this.jedisClusterNodes, this.timeout, this.timeout, 2, this.password, new GenericObjectPoolConfig());){
            String string = jedisCluster.get(metadataIdentifier.getIdentifierKey() + ".metaData");
            return string;
        }
        catch (Throwable e) {
            String msg = "Failed to get " + metadataIdentifier + " from redis cluster , cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMetadataStandalone(BaseMetadataIdentifier metadataIdentifier) {
        try (Jedis jedis = this.pool.getResource();){
            String string = jedis.get(metadataIdentifier.getUniqueKey(KeyTypeEnum.UNIQUE_KEY));
            return string;
        }
        catch (Throwable e) {
            String msg = "Failed to get " + metadataIdentifier + " from redis , cause: " + e.getMessage();
            logger.error("6-14", "", "", msg, e);
            throw new RpcException(msg, e);
        }
    }
}

