/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.hessian2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.ObjectOutput;
import org.apache.dubbo.common.serialize.Serialization;
import org.apache.dubbo.common.serialize.hessian2.Hessian2FactoryManager;
import org.apache.dubbo.common.serialize.hessian2.Hessian2ObjectInput;
import org.apache.dubbo.common.serialize.hessian2.Hessian2ObjectOutput;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class Hessian2Serialization
implements Serialization {
    public byte getContentTypeId() {
        return 2;
    }

    public String getContentType() {
        return "x-application/hessian2";
    }

    public ObjectOutput serialize(URL url, OutputStream out) throws IOException {
        Hessian2FactoryManager hessian2FactoryManager = (Hessian2FactoryManager)Optional.ofNullable(url).map(URL::getOrDefaultFrameworkModel).orElse(FrameworkModel.defaultModel()).getBeanFactory().getBean(Hessian2FactoryManager.class);
        return new Hessian2ObjectOutput(out, hessian2FactoryManager);
    }

    public ObjectInput deserialize(URL url, InputStream is) throws IOException {
        Hessian2FactoryManager hessian2FactoryManager = (Hessian2FactoryManager)Optional.ofNullable(url).map(URL::getOrDefaultFrameworkModel).orElse(FrameworkModel.defaultModel()).getBeanFactory().getBean(Hessian2FactoryManager.class);
        return new Hessian2ObjectInput(is, hessian2FactoryManager);
    }
}

