/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.RemoteEnvironmentConfigUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.WritableConfig;

@Deprecated
@Public
public class RemoteEnvironment
extends ExecutionEnvironment {
    public RemoteEnvironment(String host, int port, String ... jarFiles) {
        this(host, port, new Configuration(), jarFiles, null);
    }

    public RemoteEnvironment(String host, int port, Configuration clientConfig, String[] jarFiles) {
        this(host, port, clientConfig, jarFiles, null);
    }

    public RemoteEnvironment(String host, int port, Configuration clientConfig, String[] jarFiles, URL[] globalClasspaths) {
        super(RemoteEnvironment.validateAndGetEffectiveConfiguration(clientConfig, host, port, jarFiles, globalClasspaths));
    }

    private static Configuration validateAndGetEffectiveConfiguration(Configuration configuration, String host, int port, String[] jarFiles, URL[] globalClasspaths) {
        RemoteEnvironmentConfigUtils.validate(host, port);
        return RemoteEnvironment.getEffectiveConfiguration(RemoteEnvironment.getClientConfiguration(configuration), host, port, jarFiles, RemoteEnvironment.getClasspathURLs(globalClasspaths));
    }

    private static Configuration getClientConfiguration(Configuration configuration) {
        return configuration == null ? new Configuration() : configuration;
    }

    private static List<URL> getClasspathURLs(URL[] classpaths) {
        return classpaths == null ? Collections.emptyList() : Arrays.asList(classpaths);
    }

    private static Configuration getEffectiveConfiguration(Configuration baseConfiguration, String host, int port, String[] jars, List<URL> classpaths) {
        Configuration effectiveConfiguration = new Configuration(baseConfiguration);
        RemoteEnvironmentConfigUtils.setJobManagerAddressToConfig(host, port, effectiveConfiguration);
        RemoteEnvironmentConfigUtils.setJarURLsToConfig(jars, effectiveConfiguration);
        ConfigUtils.encodeCollectionToConfig((WritableConfig)effectiveConfiguration, (ConfigOption)PipelineOptions.CLASSPATHS, classpaths, URL::toString);
        effectiveConfiguration.setString(DeploymentOptions.TARGET, "remote");
        effectiveConfiguration.setBoolean(DeploymentOptions.ATTACHED, true);
        return effectiveConfiguration;
    }

    public String toString() {
        String host = this.getConfiguration().getString(JobManagerOptions.ADDRESS);
        int port = this.getConfiguration().getInteger(JobManagerOptions.PORT);
        String parallelism = this.getParallelism() == -1 ? "default" : "" + this.getParallelism();
        return "Remote Environment (" + host + ":" + port + " - parallelism = " + parallelism + ").";
    }
}

