/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.io.jdbc.JDBCLookupOptions;
import org.apache.flink.api.java.io.jdbc.JDBCOptions;
import org.apache.flink.api.java.io.jdbc.JDBCReadOptions;
import org.apache.flink.api.java.io.jdbc.JDBCTableSource;
import org.apache.flink.api.java.io.jdbc.JDBCUpsertTableSink;
import org.apache.flink.api.java.io.jdbc.dialect.JDBCDialects;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.JDBCValidator;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;

public class JDBCTableSourceSinkFactory
implements StreamTableSourceFactory<Row>,
StreamTableSinkFactory<Tuple2<Boolean, Row>> {
    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", "jdbc");
        context.put("connector.property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("connector.driver");
        properties.add("connector.url");
        properties.add("connector.table");
        properties.add("connector.username");
        properties.add("connector.password");
        properties.add("connector.read.partition.column");
        properties.add("connector.read.partition.num");
        properties.add("connector.read.partition.lower-bound");
        properties.add("connector.read.partition.upper-bound");
        properties.add("connector.read.fetch-size");
        properties.add("connector.lookup.cache.max-rows");
        properties.add("connector.lookup.cache.ttl");
        properties.add("connector.lookup.max-retries");
        properties.add("connector.write.flush.max-rows");
        properties.add("connector.write.flush.interval");
        properties.add("connector.write.max-retries");
        properties.add("schema.#.data-type");
        properties.add("schema.#.type");
        properties.add("schema.#.name");
        properties.add("schema.#.expr");
        properties.add("schema.watermark.#.rowtime");
        properties.add("schema.watermark.#.strategy.expr");
        properties.add("schema.watermark.#.strategy.data-type");
        return properties;
    }

    public StreamTableSource<Row> createStreamTableSource(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = this.getValidatedProperties(properties);
        TableSchema schema = TableSchemaUtils.getPhysicalSchema((TableSchema)descriptorProperties.getTableSchema("schema"));
        return JDBCTableSource.builder().setOptions(this.getJDBCOptions(descriptorProperties)).setReadOptions(this.getJDBCReadOptions(descriptorProperties)).setLookupOptions(this.getJDBCLookupOptions(descriptorProperties)).setSchema(schema).build();
    }

    public StreamTableSink<Tuple2<Boolean, Row>> createStreamTableSink(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = this.getValidatedProperties(properties);
        TableSchema schema = TableSchemaUtils.getPhysicalSchema((TableSchema)descriptorProperties.getTableSchema("schema"));
        JDBCUpsertTableSink.Builder builder = JDBCUpsertTableSink.builder().setOptions(this.getJDBCOptions(descriptorProperties)).setTableSchema(schema);
        descriptorProperties.getOptionalInt("connector.write.flush.max-rows").ifPresent(builder::setFlushMaxSize);
        descriptorProperties.getOptionalDuration("connector.write.flush.interval").ifPresent(s -> builder.setFlushIntervalMills(s.toMillis()));
        descriptorProperties.getOptionalInt("connector.write.max-retries").ifPresent(builder::setMaxRetryTimes);
        return builder.build();
    }

    private DescriptorProperties getValidatedProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        new SchemaValidator(true, false, false).validate(descriptorProperties);
        new JDBCValidator().validate(descriptorProperties);
        return descriptorProperties;
    }

    private JDBCOptions getJDBCOptions(DescriptorProperties descriptorProperties) {
        String url = descriptorProperties.getString("connector.url");
        JDBCOptions.Builder builder = JDBCOptions.builder().setDBUrl(url).setTableName(descriptorProperties.getString("connector.table")).setDialect(JDBCDialects.get(url).get());
        descriptorProperties.getOptionalString("connector.driver").ifPresent(builder::setDriverName);
        descriptorProperties.getOptionalString("connector.username").ifPresent(builder::setUsername);
        descriptorProperties.getOptionalString("connector.password").ifPresent(builder::setPassword);
        return builder.build();
    }

    private JDBCReadOptions getJDBCReadOptions(DescriptorProperties descriptorProperties) {
        Optional partitionColumnName = descriptorProperties.getOptionalString("connector.read.partition.column");
        Optional partitionLower = descriptorProperties.getOptionalLong("connector.read.partition.lower-bound");
        Optional partitionUpper = descriptorProperties.getOptionalLong("connector.read.partition.upper-bound");
        Optional numPartitions = descriptorProperties.getOptionalInt("connector.read.partition.num");
        JDBCReadOptions.Builder builder = JDBCReadOptions.builder();
        if (partitionColumnName.isPresent()) {
            builder.setPartitionColumnName((String)partitionColumnName.get());
            builder.setPartitionLowerBound((Long)partitionLower.get());
            builder.setPartitionUpperBound((Long)partitionUpper.get());
            builder.setNumPartitions((Integer)numPartitions.get());
        }
        descriptorProperties.getOptionalInt("connector.read.fetch-size").ifPresent(builder::setFetchSize);
        return builder.build();
    }

    private JDBCLookupOptions getJDBCLookupOptions(DescriptorProperties descriptorProperties) {
        JDBCLookupOptions.Builder builder = JDBCLookupOptions.builder();
        descriptorProperties.getOptionalLong("connector.lookup.cache.max-rows").ifPresent(builder::setCacheMaxSize);
        descriptorProperties.getOptionalDuration("connector.lookup.cache.ttl").ifPresent(s -> builder.setCacheExpireMs(s.toMillis()));
        descriptorProperties.getOptionalInt("connector.lookup.max-retries").ifPresent(builder::setMaxRetryTimes);
        return builder.build();
    }
}

