/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.io.jdbc.JDBCOptions;
import org.apache.flink.api.java.io.jdbc.JDBCTypeUtil;
import org.apache.flink.api.java.io.jdbc.JDBCUpsertOutputFormat;
import org.apache.flink.api.java.io.jdbc.JDBCUpsertSinkFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class JDBCUpsertTableSink
implements UpsertStreamTableSink<Row> {
    private final TableSchema schema;
    private final JDBCOptions options;
    private final int flushMaxSize;
    private final long flushIntervalMills;
    private final int maxRetryTime;
    private String[] keyFields;
    private boolean isAppendOnly;

    private JDBCUpsertTableSink(TableSchema schema, JDBCOptions options, int flushMaxSize, long flushIntervalMills, int maxRetryTime) {
        this.schema = TableSchemaUtils.checkNoGeneratedColumns((TableSchema)schema);
        this.options = options;
        this.flushMaxSize = flushMaxSize;
        this.flushIntervalMills = flushIntervalMills;
        this.maxRetryTime = maxRetryTime;
    }

    private JDBCUpsertOutputFormat newFormat() {
        if (!(this.isAppendOnly || this.keyFields != null && this.keyFields.length != 0)) {
            throw new UnsupportedOperationException("JDBCUpsertTableSink can not support ");
        }
        int[] jdbcSqlTypes = Arrays.stream(this.schema.getFieldTypes()).mapToInt(JDBCTypeUtil::typeInformationToSqlType).toArray();
        return JDBCUpsertOutputFormat.builder().setOptions(this.options).setFieldNames(this.schema.getFieldNames()).setFlushMaxSize(this.flushMaxSize).setFlushIntervalMills(this.flushIntervalMills).setMaxRetryTimes(this.maxRetryTime).setFieldTypes(jdbcSqlTypes).setKeyFields(this.keyFields).build();
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Tuple2<Boolean, Row>> dataStream) {
        return dataStream.addSink((SinkFunction)new JDBCUpsertSinkFunction(this.newFormat())).setParallelism(dataStream.getParallelism()).name(TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.schema.getFieldNames()));
    }

    public void emitDataStream(DataStream<Tuple2<Boolean, Row>> dataStream) {
        this.consumeDataStream(dataStream);
    }

    public void setKeyFields(String[] keys) {
        this.keyFields = keys;
    }

    public void setIsAppendOnly(Boolean isAppendOnly) {
        this.isAppendOnly = isAppendOnly;
    }

    public TypeInformation<Tuple2<Boolean, Row>> getOutputType() {
        return new TupleTypeInfo(new TypeInformation[]{Types.BOOLEAN, this.getRecordType()});
    }

    public TypeInformation<Row> getRecordType() {
        return new RowTypeInfo(this.schema.getFieldTypes(), this.schema.getFieldNames());
    }

    public String[] getFieldNames() {
        return this.schema.getFieldNames();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.schema.getFieldTypes();
    }

    public TableSink<Tuple2<Boolean, Row>> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        if (!Arrays.equals(this.getFieldNames(), fieldNames) || !Arrays.equals(this.getFieldTypes(), fieldTypes)) {
            throw new ValidationException("Reconfiguration with different fields is not allowed. Expected: " + Arrays.toString(this.getFieldNames()) + " / " + Arrays.toString(this.getFieldTypes()) + ". But was: " + Arrays.toString(fieldNames) + " / " + Arrays.toString(fieldTypes));
        }
        JDBCUpsertTableSink copy = new JDBCUpsertTableSink(this.schema, this.options, this.flushMaxSize, this.flushIntervalMills, this.maxRetryTime);
        copy.keyFields = this.keyFields;
        return copy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCUpsertTableSink) {
            JDBCUpsertTableSink sink = (JDBCUpsertTableSink)o;
            return Objects.equals(this.schema, sink.schema) && Objects.equals(this.options, sink.options) && Objects.equals(this.flushMaxSize, sink.flushMaxSize) && Objects.equals(this.flushIntervalMills, sink.flushIntervalMills) && Objects.equals(this.maxRetryTime, sink.maxRetryTime) && Arrays.equals(this.keyFields, sink.keyFields) && Objects.equals(this.isAppendOnly, sink.isAppendOnly);
        }
        return false;
    }

    public static class Builder {
        private TableSchema schema;
        private JDBCOptions options;
        private int flushMaxSize = 5000;
        private long flushIntervalMills = 0L;
        private int maxRetryTimes = 3;

        public Builder setTableSchema(TableSchema schema) {
            this.schema = JDBCTypeUtil.normalizeTableSchema(schema);
            return this;
        }

        public Builder setOptions(JDBCOptions options) {
            this.options = options;
            return this;
        }

        public Builder setFlushMaxSize(int flushMaxSize) {
            this.flushMaxSize = flushMaxSize;
            return this;
        }

        public Builder setFlushIntervalMills(long flushIntervalMills) {
            this.flushIntervalMills = flushIntervalMills;
            return this;
        }

        public Builder setMaxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public JDBCUpsertTableSink build() {
            Preconditions.checkNotNull((Object)this.schema, (String)"No schema supplied.");
            Preconditions.checkNotNull((Object)this.options, (String)"No options supplied.");
            return new JDBCUpsertTableSink(this.schema, this.options, this.flushMaxSize, this.flushIntervalMills, this.maxRetryTimes);
        }
    }
}

