/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc.writer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.java.io.jdbc.JDBCUtils;
import org.apache.flink.api.java.io.jdbc.dialect.JDBCDialect;
import org.apache.flink.api.java.io.jdbc.writer.JDBCWriter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public abstract class UpsertWriter
implements JDBCWriter {
    private static final long serialVersionUID = 1L;
    final int[] fieldTypes;
    final int[] pkTypes;
    private final int[] pkFields;
    private final String deleteSQL;
    private transient Map<Row, Tuple2<Boolean, Row>> keyToRows;
    private transient PreparedStatement deleteStatement;

    public static UpsertWriter create(JDBCDialect dialect, String tableName, String[] fieldNames, int[] fieldTypes, String[] keyFields) {
        Preconditions.checkNotNull((Object)keyFields);
        List<String> nameList = Arrays.asList(fieldNames);
        int[] pkFields = Arrays.stream(keyFields).mapToInt(nameList::indexOf).toArray();
        int[] pkTypes = fieldTypes == null ? null : Arrays.stream(pkFields).map(f -> fieldTypes[f]).toArray();
        String deleteSQL = dialect.getDeleteStatement(tableName, keyFields);
        Optional<String> upsertSQL = dialect.getUpsertStatement(tableName, fieldNames, keyFields);
        return upsertSQL.map(sql -> new UpsertWriterUsingUpsertStatement(fieldTypes, pkFields, pkTypes, deleteSQL, (String)sql)).orElseGet(() -> new UpsertWriterUsingInsertUpdateStatement(fieldTypes, pkFields, pkTypes, deleteSQL, dialect.getRowExistsStatement(tableName, keyFields), dialect.getInsertIntoStatement(tableName, fieldNames), dialect.getUpdateStatement(tableName, fieldNames, keyFields)));
    }

    private UpsertWriter(int[] fieldTypes, int[] pkFields, int[] pkTypes, String deleteSQL) {
        this.fieldTypes = fieldTypes;
        this.pkFields = pkFields;
        this.pkTypes = pkTypes;
        this.deleteSQL = deleteSQL;
    }

    @Override
    public void open(Connection connection) throws SQLException {
        this.keyToRows = new HashMap<Row, Tuple2<Boolean, Row>>();
        this.deleteStatement = connection.prepareStatement(this.deleteSQL);
    }

    @Override
    public void addRecord(Tuple2<Boolean, Row> record) {
        this.keyToRows.put(this.getPrimaryKey((Row)record.f1), record);
    }

    @Override
    public void executeBatch() throws SQLException {
        if (this.keyToRows.size() > 0) {
            for (Map.Entry<Row, Tuple2<Boolean, Row>> entry : this.keyToRows.entrySet()) {
                Row pk = entry.getKey();
                Tuple2<Boolean, Row> tuple = entry.getValue();
                if (((Boolean)tuple.f0).booleanValue()) {
                    this.processOneRowInBatch(pk, (Row)tuple.f1);
                    continue;
                }
                JDBCUtils.setRecordToStatement(this.deleteStatement, this.pkTypes, pk);
                this.deleteStatement.addBatch();
            }
            this.internalExecuteBatch();
            this.deleteStatement.executeBatch();
            this.keyToRows.clear();
        }
    }

    abstract void processOneRowInBatch(Row var1, Row var2) throws SQLException;

    abstract void internalExecuteBatch() throws SQLException;

    @Override
    public void close() throws SQLException {
        if (this.deleteStatement != null) {
            this.deleteStatement.close();
            this.deleteStatement = null;
        }
    }

    private Row getPrimaryKey(Row row) {
        Row pks = new Row(this.pkFields.length);
        for (int i = 0; i < this.pkFields.length; ++i) {
            pks.setField(i, row.getField(this.pkFields[i]));
        }
        return pks;
    }

    private static final class UpsertWriterUsingInsertUpdateStatement
    extends UpsertWriter {
        private static final long serialVersionUID = 1L;
        private final String existSQL;
        private final String insertSQL;
        private final String updateSQL;
        private transient PreparedStatement existStatement;
        private transient PreparedStatement insertStatement;
        private transient PreparedStatement updateStatement;

        private UpsertWriterUsingInsertUpdateStatement(int[] fieldTypes, int[] pkFields, int[] pkTypes, String deleteSQL, String existSQL, String insertSQL, String updateSQL) {
            super(fieldTypes, pkFields, pkTypes, deleteSQL);
            this.existSQL = existSQL;
            this.insertSQL = insertSQL;
            this.updateSQL = updateSQL;
        }

        @Override
        public void open(Connection connection) throws SQLException {
            super.open(connection);
            this.existStatement = connection.prepareStatement(this.existSQL);
            this.insertStatement = connection.prepareStatement(this.insertSQL);
            this.updateStatement = connection.prepareStatement(this.updateSQL);
        }

        @Override
        void processOneRowInBatch(Row pk, Row row) throws SQLException {
            JDBCUtils.setRecordToStatement(this.existStatement, this.pkTypes, pk);
            ResultSet resultSet = this.existStatement.executeQuery();
            boolean exist = resultSet.next();
            resultSet.close();
            if (exist) {
                JDBCUtils.setRecordToStatement(this.updateStatement, this.fieldTypes, row);
                this.updateStatement.addBatch();
            } else {
                JDBCUtils.setRecordToStatement(this.insertStatement, this.fieldTypes, row);
                this.insertStatement.addBatch();
            }
        }

        @Override
        void internalExecuteBatch() throws SQLException {
            this.updateStatement.executeBatch();
            this.insertStatement.executeBatch();
        }

        @Override
        public void close() throws SQLException {
            super.close();
            if (this.existStatement != null) {
                this.existStatement.close();
                this.existStatement = null;
            }
            if (this.insertStatement != null) {
                this.insertStatement.close();
                this.insertStatement = null;
            }
            if (this.updateStatement != null) {
                this.updateStatement.close();
                this.updateStatement = null;
            }
        }
    }

    private static final class UpsertWriterUsingUpsertStatement
    extends UpsertWriter {
        private static final long serialVersionUID = 1L;
        private final String upsertSQL;
        private transient PreparedStatement upsertStatement;

        private UpsertWriterUsingUpsertStatement(int[] fieldTypes, int[] pkFields, int[] pkTypes, String deleteSQL, String upsertSQL) {
            super(fieldTypes, pkFields, pkTypes, deleteSQL);
            this.upsertSQL = upsertSQL;
        }

        @Override
        public void open(Connection connection) throws SQLException {
            super.open(connection);
            this.upsertStatement = connection.prepareStatement(this.upsertSQL);
        }

        @Override
        void processOneRowInBatch(Row pk, Row row) throws SQLException {
            JDBCUtils.setRecordToStatement(this.upsertStatement, this.fieldTypes, row);
            this.upsertStatement.addBatch();
        }

        @Override
        void internalExecuteBatch() throws SQLException {
            this.upsertStatement.executeBatch();
        }

        @Override
        public void close() throws SQLException {
            super.close();
            if (this.upsertStatement != null) {
                this.upsertStatement.close();
                this.upsertStatement = null;
            }
        }
    }
}

