/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.outlier;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.functions.euclideanDistance$;
import breeze.linalg.norm$;
import breeze.linalg.sum$;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.api.scala.utils.package$;
import org.apache.flink.ml.common.LabeledVector;
import org.apache.flink.ml.common.ParameterMap;
import org.apache.flink.ml.common.WithParameters;
import org.apache.flink.ml.common.WithParameters$class;
import org.apache.flink.ml.math.Breeze$;
import org.apache.flink.ml.math.BreezeVectorConverter;
import org.apache.flink.ml.outlier.StochasticOutlierSelection;
import org.apache.flink.ml.outlier.StochasticOutlierSelection$;
import org.apache.flink.ml.outlier.StochasticOutlierSelection$$anon$17$;
import org.apache.flink.ml.outlier.StochasticOutlierSelection$$anon$18$;
import org.apache.flink.ml.outlier.StochasticOutlierSelection$ErrorTolerance$;
import org.apache.flink.ml.outlier.StochasticOutlierSelection$MaxIterations$;
import org.apache.flink.ml.outlier.StochasticOutlierSelection$Perplexity$;
import org.apache.flink.ml.pipeline.TransformDataSetOperation;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class StochasticOutlierSelection$
implements WithParameters,
Serializable {
    public static final StochasticOutlierSelection$ MODULE$;
    private final Object transformLabeledVectors;
    private final ParameterMap parameters;

    static {
        new StochasticOutlierSelection$();
    }

    @Override
    public ParameterMap parameters() {
        return this.parameters;
    }

    @Override
    public void org$apache$flink$ml$common$WithParameters$_setter_$parameters_$eq(ParameterMap x$1) {
        this.parameters = x$1;
    }

    public StochasticOutlierSelection apply() {
        return new StochasticOutlierSelection();
    }

    public Object transformLabeledVectors() {
        return this.transformLabeledVectors;
    }

    public <T extends org.apache.flink.ml.math.Vector> Object transformVectors(BreezeVectorConverter<T> evidence$1, TypeInformation<T> evidence$2, ClassTag<T> evidence$3) {
        return new TransformDataSetOperation<StochasticOutlierSelection, T, Object>(evidence$2, evidence$3){
            private final TypeInformation evidence$2$1;
            private final ClassTag evidence$3$1;

            public DataSet<Object> transformDataSet(StochasticOutlierSelection instance, ParameterMap transformParameters, DataSet<T> input) {
                ParameterMap resultingParameters = instance.parameters().$plus$plus(transformParameters);
                DataSet vectorsWithIndex = package$.MODULE$.DataSetUtils(input, this.evidence$2$1, this.evidence$3$1).zipWithUniqueId().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StochasticOutlierSelection.BreezeLabeledVector apply(Tuple2<Object, T> vector) {
                        return new StochasticOutlierSelection.BreezeLabeledVector((int)vector._1$mcJ$sp(), Breeze$.MODULE$.Vector2BreezeConverter((org.apache.flink.ml.math.Vector)vector._2()).asBreeze());
                    }
                }, (TypeInformation)new CaseClassTypeInfo<StochasticOutlierSelection.BreezeLabeledVector>(this){

                    public /* synthetic */ TypeInformation[] protected$types(anon$18$$anon$10 x$1) {
                        return x$1.types;
                    }

                    public TypeSerializer<StochasticOutlierSelection.BreezeLabeledVector> createSerializer(ExecutionConfig executionConfig) {
                        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon$18$$anon$10 $outer;
                            private final ExecutionConfig executionConfig$2;
                            private final TypeSerializer[] fieldSerializers$2;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.executionConfig$2 = executionConfig$2;
                                this.fieldSerializers$2 = fieldSerializers$2;
                            }
                        });
                        ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector> unused = new ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector>(this, fieldSerializers){

                            public StochasticOutlierSelection.BreezeLabeledVector createInstance(Object[] fields) {
                                return new StochasticOutlierSelection.BreezeLabeledVector(BoxesRunTime.unboxToInt((Object)fields[0]), (Vector<Object>)((Vector)fields[1]));
                            }
                        };
                        return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                    }
                }, ClassTag$.MODULE$.apply(StochasticOutlierSelection.BreezeLabeledVector.class));
                return StochasticOutlierSelection$.MODULE$.org$apache$flink$ml$outlier$StochasticOutlierSelection$$outlierSelection((DataSet<StochasticOutlierSelection.BreezeLabeledVector>)vectorsWithIndex, resultingParameters).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x$1) {
                        return x$1._2$mcD$sp();
                    }
                }, (TypeInformation)BasicTypeInfo.getInfoFor(Double.TYPE), ClassTag$.MODULE$.Double());
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.evidence$3$1 = evidence$3$1;
            }
        };
    }

    public DataSet<Tuple2<Object, Object>> org$apache$flink$ml$outlier$StochasticOutlierSelection$$outlierSelection(DataSet<StochasticOutlierSelection.BreezeLabeledVector> inputVectors, ParameterMap transformParameters) {
        DataSet<StochasticOutlierSelection.BreezeLabeledVector> dissimilarityVectors = this.computeDissimilarityVectors(inputVectors);
        DataSet<StochasticOutlierSelection.BreezeLabeledVector> affinityVectors = this.computeAffinity(dissimilarityVectors, transformParameters);
        DataSet<StochasticOutlierSelection.BreezeLabeledVector> bindingProbabilityVectors = this.computeBindingProbabilities(affinityVectors);
        DataSet<Tuple2<Object, Object>> outlierProbability = this.computeOutlierProbability(bindingProbabilityVectors);
        return outlierProbability;
    }

    public DataSet<StochasticOutlierSelection.BreezeLabeledVector> computeDissimilarityVectors(DataSet<StochasticOutlierSelection.BreezeLabeledVector> inputVectors) {
        return inputVectors.cross(inputVectors).apply((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(StochasticOutlierSelection.BreezeLabeledVector a, StochasticOutlierSelection.BreezeLabeledVector b) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)a.idx()), (Object)BoxesRunTime.boxToInteger((int)b.idx()), euclideanDistance$.MODULE$.apply(a.data(), b.data(), euclideanDistance$.MODULE$.distanceFromNormAndSub((UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub(), Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double()))));
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple3<Object, Object, Object>>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.11 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple3<Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.11 $outer;
                    private final ExecutionConfig executionConfig$3;
                    private final TypeSerializer[] fieldSerializers$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$3 = executionConfig$3;
                        this.fieldSerializers$3 = fieldSerializers$3;
                    }
                });
                ScalaCaseClassSerializer<Tuple3<Object, Object, Object>> unused = new ScalaCaseClassSerializer<Tuple3<Object, Object, Object>>(this, fieldSerializers){

                    public Tuple3<Object, Object, Object> createInstance(Object[] fields) {
                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<Object, Object, Object> dist) {
                return BoxesRunTime.unboxToInt((Object)dist._1()) != BoxesRunTime.unboxToInt((Object)dist._2());
            }
        }).groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).sortGroup(1, Order.ASCENDING).reduceGroup((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StochasticOutlierSelection.BreezeLabeledVector apply(Iterator<Tuple3<Object, Object, Object>> distancesIterator) {
                List distances = distancesIterator.toList();
                double[] distanceVector = (double[])((TraversableOnce)distances.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple3<Object, Object, Object> x$2) {
                        return BoxesRunTime.unboxToDouble((Object)x$2._3());
                    }
                }, List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                return new StochasticOutlierSelection.BreezeLabeledVector(BoxesRunTime.unboxToInt((Object)((Tuple3)distances.head())._1()), (Vector<Object>)DenseVector$.MODULE$.apply$mDc$sp(distanceVector));
            }
        }, (TypeInformation)new CaseClassTypeInfo<StochasticOutlierSelection.BreezeLabeledVector>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.12 x$1) {
                return x$1.types;
            }

            public TypeSerializer<StochasticOutlierSelection.BreezeLabeledVector> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.12 $outer;
                    private final ExecutionConfig executionConfig$4;
                    private final TypeSerializer[] fieldSerializers$4;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$4[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$4 = executionConfig$4;
                        this.fieldSerializers$4 = fieldSerializers$4;
                    }
                });
                ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector> unused = new ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector>(this, fieldSerializers){

                    public StochasticOutlierSelection.BreezeLabeledVector createInstance(Object[] fields) {
                        return new StochasticOutlierSelection.BreezeLabeledVector(BoxesRunTime.unboxToInt((Object)fields[0]), (Vector<Object>)((Vector)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }, ClassTag$.MODULE$.apply(StochasticOutlierSelection.BreezeLabeledVector.class));
    }

    public DataSet<StochasticOutlierSelection.BreezeLabeledVector> computeAffinity(DataSet<StochasticOutlierSelection.BreezeLabeledVector> dissimilarityVectors, ParameterMap resultingParameters) {
        double logPerplexity = Math.log(BoxesRunTime.unboxToDouble((Object)resultingParameters.apply(StochasticOutlierSelection$Perplexity$.MODULE$)));
        int maxIterations = BoxesRunTime.unboxToInt((Object)resultingParameters.apply(StochasticOutlierSelection$MaxIterations$.MODULE$));
        double errorTolerance = BoxesRunTime.unboxToDouble((Object)resultingParameters.apply(StochasticOutlierSelection$ErrorTolerance$.MODULE$));
        return dissimilarityVectors.map((Function1)new Serializable(logPerplexity, maxIterations, errorTolerance){
            public static final long serialVersionUID = 0L;
            private final double logPerplexity$1;
            private final int maxIterations$1;
            private final double errorTolerance$1;

            public final StochasticOutlierSelection.BreezeLabeledVector apply(StochasticOutlierSelection.BreezeLabeledVector vec) {
                Vector<Object> breezeVec = StochasticOutlierSelection$.MODULE$.binarySearch(vec.data(), this.logPerplexity$1, this.maxIterations$1, this.errorTolerance$1, StochasticOutlierSelection$.MODULE$.binarySearch$default$5(), StochasticOutlierSelection$.MODULE$.binarySearch$default$6(), StochasticOutlierSelection$.MODULE$.binarySearch$default$7(), StochasticOutlierSelection$.MODULE$.binarySearch$default$8());
                return new StochasticOutlierSelection.BreezeLabeledVector(vec.idx(), breezeVec);
            }
            {
                this.logPerplexity$1 = logPerplexity$1;
                this.maxIterations$1 = maxIterations$1;
                this.errorTolerance$1 = errorTolerance$1;
            }
        }, (TypeInformation)new CaseClassTypeInfo<StochasticOutlierSelection.BreezeLabeledVector>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.13 x$1) {
                return x$1.types;
            }

            public TypeSerializer<StochasticOutlierSelection.BreezeLabeledVector> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.13 $outer;
                    private final ExecutionConfig executionConfig$5;
                    private final TypeSerializer[] fieldSerializers$5;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$5[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$5);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$5 = executionConfig$5;
                        this.fieldSerializers$5 = fieldSerializers$5;
                    }
                });
                ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector> unused = new ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector>(this, fieldSerializers){

                    public StochasticOutlierSelection.BreezeLabeledVector createInstance(Object[] fields) {
                        return new StochasticOutlierSelection.BreezeLabeledVector(BoxesRunTime.unboxToInt((Object)fields[0]), (Vector<Object>)((Vector)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }, ClassTag$.MODULE$.apply(StochasticOutlierSelection.BreezeLabeledVector.class));
    }

    public DataSet<StochasticOutlierSelection.BreezeLabeledVector> computeBindingProbabilities(DataSet<StochasticOutlierSelection.BreezeLabeledVector> affinityVectors) {
        return affinityVectors.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StochasticOutlierSelection.BreezeLabeledVector apply(StochasticOutlierSelection.BreezeLabeledVector vec) {
                return new StochasticOutlierSelection.BreezeLabeledVector(vec.idx(), (Vector<Object>)((Vector)vec.data().$colon$div(sum$.MODULE$.apply(vec.data(), sum$.MODULE$.reduce_Double(Vector$.MODULE$.canIterateValues())), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv())));
            }
        }, (TypeInformation)new CaseClassTypeInfo<StochasticOutlierSelection.BreezeLabeledVector>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.14 x$1) {
                return x$1.types;
            }

            public TypeSerializer<StochasticOutlierSelection.BreezeLabeledVector> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.14 $outer;
                    private final ExecutionConfig executionConfig$6;
                    private final TypeSerializer[] fieldSerializers$6;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$6[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$6);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$6 = executionConfig$6;
                        this.fieldSerializers$6 = fieldSerializers$6;
                    }
                });
                ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector> unused = new ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector>(this, fieldSerializers){

                    public StochasticOutlierSelection.BreezeLabeledVector createInstance(Object[] fields) {
                        return new StochasticOutlierSelection.BreezeLabeledVector(BoxesRunTime.unboxToInt((Object)fields[0]), (Vector<Object>)((Vector)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }, ClassTag$.MODULE$.apply(StochasticOutlierSelection.BreezeLabeledVector.class));
    }

    public DataSet<Tuple2<Object, Object>> computeOutlierProbability(DataSet<StochasticOutlierSelection.BreezeLabeledVector> bindingProbabilityVectors) {
        return bindingProbabilityVectors.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Tuple2<Object, Object>> apply(StochasticOutlierSelection.BreezeLabeledVector vec) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(vec.data().toArray$mcD$sp(ClassTag$.MODULE$.Double())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, vec){
                    public static final long serialVersionUID = 0L;
                    private final StochasticOutlierSelection.BreezeLabeledVector vec$1;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> pair) {
                        int columnIndex = pair._2$mcI$sp() >= this.vec$1.idx() ? 1 : 0;
                        return new Tuple2.mcID.sp(columnIndex + pair._2$mcI$sp(), pair._1$mcD$sp());
                    }
                    {
                        this.vec$1 = vec$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.15 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.15 $outer;
                    private final ExecutionConfig executionConfig$7;
                    private final TypeSerializer[] fieldSerializers$7;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$7[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$7);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$7 = executionConfig$7;
                        this.fieldSerializers$7 = fieldSerializers$7;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcID.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).groupBy((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})).reduceGroup((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Iterator<Tuple2<Object, Object>> probabilities) {
                IntRef rowNumber = IntRef.create((int)-1);
                DoubleRef outlierProbability = DoubleRef.create((double)1.0);
                probabilities.foreach((Function1)new Serializable(this, rowNumber, outlierProbability){
                    public static final long serialVersionUID = 0L;
                    private final IntRef rowNumber$1;
                    private final DoubleRef outlierProbability$1;

                    public final void apply(Tuple2<Object, Object> probability) {
                        this.rowNumber$1.elem = probability._1$mcI$sp();
                        this.outlierProbability$1.elem *= 1.0 - probability._2$mcD$sp();
                    }
                    {
                        this.rowNumber$1 = rowNumber$1;
                        this.outlierProbability$1 = outlierProbability$1;
                    }
                });
                return new Tuple2.mcID.sp(rowNumber.elem, outlierProbability.elem);
            }
        }, (TypeInformation)new CaseClassTypeInfo<Tuple2<Object, Object>>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.16 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.16 $outer;
                    private final ExecutionConfig executionConfig$8;
                    private final TypeSerializer[] fieldSerializers$8;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$8[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$8);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionConfig$8 = executionConfig$8;
                        this.fieldSerializers$8 = fieldSerializers$8;
                    }
                });
                ScalaCaseClassSerializer<Tuple2<Object, Object>> unused = new ScalaCaseClassSerializer<Tuple2<Object, Object>>(this, fieldSerializers){

                    public Tuple2<Object, Object> createInstance(Object[] fields) {
                        return new Tuple2.mcID.sp(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToDouble((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Vector<Object> binarySearch(Vector<Object> dissimilarityVector, double logPerplexity, int maxIterations, double tolerance, double beta, double betaMin, double betaMax, int iteration) {
        Vector newAffinity;
        block5: {
            Tuple3 tuple3;
            while (true) {
                Tuple3 tuple32;
                Tuple3 tuple33;
                newAffinity = (Vector)dissimilarityVector.map$mcD$sp((Function1)new Serializable(beta){
                    public static final long serialVersionUID = 0L;
                    private final double beta$1;

                    public final double apply(double d) {
                        return this.apply$mcDD$sp(d);
                    }

                    public double apply$mcDD$sp(double d) {
                        return Math.exp(-d * this.beta$1);
                    }
                    {
                        this.beta$1 = beta$1;
                    }
                }, Vector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double()));
                double sumA = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)newAffinity, sum$.MODULE$.reduce_Double(Vector$.MODULE$.canIterateValues())));
                double hCurr = Math.log(sumA) + beta * BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(dissimilarityVector.$colon$times((Object)newAffinity, (UFunc.UImpl2)Vector$.MODULE$.v_v_nilpotent_Op_Double()), sum$.MODULE$.reduce_Double(Vector$.MODULE$.canIterateValues()))) / sumA;
                double hDiff = hCurr - logPerplexity;
                if (iteration >= maxIterations || !(Math.abs(hDiff) > tolerance)) break block5;
                if (Predef$.MODULE$.double2Double(hDiff).isNaN()) {
                    tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)(beta / 10.0)), (Object)BoxesRunTime.boxToDouble((double)betaMin), (Object)BoxesRunTime.boxToDouble((double)betaMax));
                } else if (hDiff > 0.0) {
                    double newBeta = betaMax == Double.POSITIVE_INFINITY || betaMax == Double.NEGATIVE_INFINITY ? beta * 2.0 : (beta + betaMax) / 2.0;
                    tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)newBeta), (Object)BoxesRunTime.boxToDouble((double)beta), (Object)BoxesRunTime.boxToDouble((double)betaMax));
                } else {
                    double newBeta = betaMin == Double.POSITIVE_INFINITY || betaMin == Double.NEGATIVE_INFINITY ? beta / 2.0 : (beta + betaMin) / 2.0;
                    tuple33 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)newBeta), (Object)BoxesRunTime.boxToDouble((double)betaMin), (Object)BoxesRunTime.boxToDouble((double)beta));
                }
                if (tuple3 == null) break;
                double newBeta = BoxesRunTime.unboxToDouble((Object)tuple3._1());
                double newBetaMin = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double newBetaMax = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                Tuple3 tuple34 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)newBeta), (Object)BoxesRunTime.boxToDouble((double)newBetaMin), (Object)BoxesRunTime.boxToDouble((double)newBetaMax));
                double newBeta2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
                double newBetaMin2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                double newBetaMax2 = BoxesRunTime.unboxToDouble((Object)tuple34._3());
                ++iteration;
                betaMax = newBetaMax2;
                betaMin = newBetaMin2;
                beta = newBeta2;
            }
            throw new MatchError((Object)tuple3);
        }
        return newAffinity;
    }

    public double binarySearch$default$5() {
        return 1.0;
    }

    public double binarySearch$default$6() {
        return Double.NEGATIVE_INFINITY;
    }

    public double binarySearch$default$7() {
        return Double.POSITIVE_INFINITY;
    }

    public int binarySearch$default$8() {
        return 0;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private StochasticOutlierSelection$() {
        MODULE$ = this;
        WithParameters$class.$init$(this);
        this.transformLabeledVectors = new TransformDataSetOperation<StochasticOutlierSelection, LabeledVector, Tuple2<Object, Object>>(){

            public DataSet<Tuple2<Object, Object>> transformDataSet(StochasticOutlierSelection instance, ParameterMap transformParameters, DataSet<LabeledVector> input) {
                ParameterMap resultingParameters = instance.parameters().$plus$plus(transformParameters);
                DataSet vectorsWithIndex = input.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final StochasticOutlierSelection.BreezeLabeledVector apply(LabeledVector labeledVector) {
                        return new StochasticOutlierSelection.BreezeLabeledVector((int)labeledVector.label(), Breeze$.MODULE$.Vector2BreezeConverter(labeledVector.vector()).asBreeze());
                    }
                }, (TypeInformation)new CaseClassTypeInfo<StochasticOutlierSelection.BreezeLabeledVector>(this){

                    public /* synthetic */ TypeInformation[] protected$types(anon$17$$anon$9 x$1) {
                        return x$1.types;
                    }

                    public TypeSerializer<StochasticOutlierSelection.BreezeLabeledVector> createSerializer(ExecutionConfig executionConfig) {
                        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon$17$$anon$9 $outer;
                            private final ExecutionConfig executionConfig$1;
                            private final TypeSerializer[] fieldSerializers$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.executionConfig$1 = executionConfig$1;
                                this.fieldSerializers$1 = fieldSerializers$1;
                            }
                        });
                        ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector> unused = new ScalaCaseClassSerializer<StochasticOutlierSelection.BreezeLabeledVector>(this, fieldSerializers){

                            public StochasticOutlierSelection.BreezeLabeledVector createInstance(Object[] fields) {
                                return new StochasticOutlierSelection.BreezeLabeledVector(BoxesRunTime.unboxToInt((Object)fields[0]), (Vector<Object>)((Vector)fields[1]));
                            }
                        };
                        return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                    }
                }, ClassTag$.MODULE$.apply(StochasticOutlierSelection.BreezeLabeledVector.class));
                return StochasticOutlierSelection$.MODULE$.org$apache$flink$ml$outlier$StochasticOutlierSelection$$outlierSelection((DataSet<StochasticOutlierSelection.BreezeLabeledVector>)vectorsWithIndex, resultingParameters);
            }
        };
    }
}

