/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.classloading.SubmoduleClassLoader;
import org.apache.flink.runtime.rpc.AddressResolution;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanupOnCloseRpcSystem
implements RpcSystem {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupOnCloseRpcSystem.class);
    private final RpcSystem rpcSystem;
    private final SubmoduleClassLoader pluginLoader;
    private final Path tempFile;

    public CleanupOnCloseRpcSystem(RpcSystem rpcSystem, SubmoduleClassLoader pluginLoader, Path tempFile) {
        this.rpcSystem = (RpcSystem)Preconditions.checkNotNull((Object)rpcSystem);
        this.pluginLoader = (SubmoduleClassLoader)Preconditions.checkNotNull((Object)pluginLoader);
        this.tempFile = (Path)Preconditions.checkNotNull((Object)tempFile);
    }

    public void close() {
        this.rpcSystem.close();
        try {
            this.pluginLoader.close();
        }
        catch (Exception e) {
            LOG.warn("Could not close RpcSystem classloader.", (Throwable)e);
        }
        try {
            Files.delete(this.tempFile);
        }
        catch (Exception e) {
            LOG.warn("Could not delete temporary rpc system file {}.", (Object)this.tempFile, (Object)e);
        }
    }

    public RpcSystem.RpcServiceBuilder localServiceBuilder(Configuration config) {
        return this.rpcSystem.localServiceBuilder(config);
    }

    public RpcSystem.RpcServiceBuilder remoteServiceBuilder(Configuration configuration, @Nullable String externalAddress, String externalPortRange) {
        return this.rpcSystem.remoteServiceBuilder(configuration, externalAddress, externalPortRange);
    }

    public String getRpcUrl(String hostname, int port, String endpointName, AddressResolution addressResolution, Configuration config) throws UnknownHostException {
        return this.rpcSystem.getRpcUrl(hostname, port, endpointName, addressResolution, config);
    }

    public InetSocketAddress getInetSocketAddressFromRpcUrl(String url) throws Exception {
        return this.rpcSystem.getInetSocketAddressFromRpcUrl(url);
    }

    public long getMaximumMessageSizeInBytes(Configuration config) {
        return this.rpcSystem.getMaximumMessageSizeInBytes(config);
    }
}

