/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.HistoryServerOptions;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.runtime.rest.handler.router.Router;
import org.apache.flink.runtime.rest.messages.DashboardConfiguration;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.webmonitor.history.HistoryServerArchiveFetcher;
import org.apache.flink.runtime.webmonitor.history.HistoryServerStaticFileServerHandler;
import org.apache.flink.runtime.webmonitor.history.HistoryServerUtils;
import org.apache.flink.runtime.webmonitor.utils.WebFrontendBootstrap;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryServer {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Configuration config;
    private final String webAddress;
    private final int webPort;
    private final long webRefreshIntervalMillis;
    private final File webDir;
    private final HistoryServerArchiveFetcher archiveFetcher;
    @Nullable
    private final SSLHandlerFactory serverSSLFactory;
    private WebFrontendBootstrap netty;
    private final Object startupShutdownLock = new Object();
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final Thread shutdownHook;

    public static void main(String[] args) throws Exception {
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"HistoryServer", (String[])args);
        ParameterTool pt = ParameterTool.fromArgs((String[])args);
        String configDir = pt.getRequired("configDir");
        LOG.info("Loading configuration from {}", (Object)configDir);
        final Configuration flinkConfig = GlobalConfiguration.loadConfiguration((String)configDir);
        FileSystem.initialize((Configuration)flinkConfig, (PluginManager)PluginUtils.createPluginManagerFromRootFolder((Configuration)flinkConfig));
        SecurityUtils.install((SecurityConfiguration)new SecurityConfiguration(flinkConfig));
        try {
            SecurityUtils.getInstalledContext().runSecured((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    HistoryServer hs = new HistoryServer(flinkConfig);
                    hs.run();
                    return 0;
                }
            });
            System.exit(0);
        }
        catch (Throwable t) {
            Throwable strippedThrowable = ExceptionUtils.stripException((Throwable)t, UndeclaredThrowableException.class);
            LOG.error("Failed to run HistoryServer.", strippedThrowable);
            strippedThrowable.printStackTrace();
            System.exit(1);
        }
    }

    public HistoryServer(Configuration config) throws IOException, FlinkException {
        this(config, event -> {});
    }

    public HistoryServer(Configuration config, Consumer<HistoryServerArchiveFetcher.ArchiveEvent> jobArchiveEventListener) throws IOException, FlinkException {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull(jobArchiveEventListener);
        this.config = config;
        if (HistoryServerUtils.isSSLEnabled((Configuration)config)) {
            LOG.info("Enabling SSL for the history server.");
            try {
                this.serverSSLFactory = SSLUtils.createRestServerSSLEngineFactory((Configuration)config);
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize SSLContext for the history server.", e);
            }
        } else {
            this.serverSSLFactory = null;
        }
        this.webAddress = config.getString(HistoryServerOptions.HISTORY_SERVER_WEB_ADDRESS);
        this.webPort = config.getInteger(HistoryServerOptions.HISTORY_SERVER_WEB_PORT);
        this.webRefreshIntervalMillis = config.getLong(HistoryServerOptions.HISTORY_SERVER_WEB_REFRESH_INTERVAL);
        String webDirectory = config.getString(HistoryServerOptions.HISTORY_SERVER_WEB_DIR);
        if (webDirectory == null) {
            webDirectory = System.getProperty("java.io.tmpdir") + File.separator + "flink-web-history-" + UUID.randomUUID();
        }
        this.webDir = new File(webDirectory);
        boolean cleanupExpiredArchives = config.getBoolean(HistoryServerOptions.HISTORY_SERVER_CLEANUP_EXPIRED_JOBS);
        String refreshDirectories = config.getString(HistoryServerOptions.HISTORY_SERVER_ARCHIVE_DIRS);
        if (refreshDirectories == null) {
            throw new FlinkException(HistoryServerOptions.HISTORY_SERVER_ARCHIVE_DIRS + " was not configured.");
        }
        ArrayList<RefreshLocation> refreshDirs = new ArrayList<RefreshLocation>();
        for (String refreshDirectory : refreshDirectories.split(",")) {
            try {
                Path refreshPath = new Path(refreshDirectory);
                FileSystem refreshFS = refreshPath.getFileSystem();
                refreshDirs.add(new RefreshLocation(refreshPath, refreshFS));
            }
            catch (Exception e) {
                LOG.warn("Failed to create Path or FileSystem for directory '{}'. Directory will not be monitored.", (Object)refreshDirectory, (Object)e);
            }
        }
        if (refreshDirs.isEmpty()) {
            throw new FlinkException("Failed to validate any of the configured directories to monitor.");
        }
        long refreshIntervalMillis = config.getLong(HistoryServerOptions.HISTORY_SERVER_ARCHIVE_REFRESH_INTERVAL);
        int maxHistorySize = config.getInteger(HistoryServerOptions.HISTORY_SERVER_RETAINED_JOBS);
        if (maxHistorySize == 0 || maxHistorySize < -1) {
            throw new IllegalConfigurationException("Cannot set %s to 0 or less than -1", new Object[]{HistoryServerOptions.HISTORY_SERVER_RETAINED_JOBS.key()});
        }
        this.archiveFetcher = new HistoryServerArchiveFetcher(refreshIntervalMillis, refreshDirs, this.webDir, jobArchiveEventListener, cleanupExpiredArchives, maxHistorySize);
        this.shutdownHook = ShutdownHookUtil.addShutdownHook(this::stop, (String)HistoryServer.class.getSimpleName(), (Logger)LOG);
    }

    @VisibleForTesting
    int getWebPort() {
        return this.netty.getServerPort();
    }

    public void run() {
        try {
            this.start();
            new CountDownLatch(1).await();
        }
        catch (Exception e) {
            LOG.error("Failure while running HistoryServer.", (Throwable)e);
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws IOException, InterruptedException {
        Object object = this.startupShutdownLock;
        synchronized (object) {
            LOG.info("Starting history server.");
            Files.createDirectories(this.webDir.toPath(), new FileAttribute[0]);
            LOG.info("Using directory {} as local cache.", (Object)this.webDir);
            Router router = new Router();
            router.addGet("/:*", (Object)new HistoryServerStaticFileServerHandler(this.webDir));
            this.createDashboardConfigFile();
            this.archiveFetcher.start();
            this.netty = new WebFrontendBootstrap(router, LOG, this.webDir, this.serverSSLFactory, this.webAddress, this.webPort, this.config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.shutdownRequested.compareAndSet(false, true)) {
            Object object = this.startupShutdownLock;
            synchronized (object) {
                LOG.info("Stopping history server.");
                try {
                    this.netty.shutdown();
                }
                catch (Throwable t) {
                    LOG.warn("Error while shutting down WebFrontendBootstrap.", t);
                }
                this.archiveFetcher.stop();
                try {
                    LOG.info("Removing web dashboard root cache directory {}", (Object)this.webDir);
                    FileUtils.deleteDirectory((File)this.webDir);
                }
                catch (Throwable t) {
                    LOG.warn("Error while deleting web root directory {}", (Object)this.webDir, (Object)t);
                }
                LOG.info("Stopped history server.");
                ShutdownHookUtil.removeShutdownHook((Thread)this.shutdownHook, (String)this.getClass().getSimpleName(), (Logger)LOG);
            }
        }
    }

    static FileWriter createOrGetFile(File folder, String name) throws IOException {
        File file = new File(folder, name + ".json");
        if (!file.exists()) {
            Files.createFile(file.toPath(), new FileAttribute[0]);
        }
        FileWriter fr = new FileWriter(file);
        return fr;
    }

    private void createDashboardConfigFile() throws IOException {
        try (FileWriter fw = HistoryServer.createOrGetFile(this.webDir, "config");){
            fw.write(HistoryServer.createConfigJson(DashboardConfiguration.from((long)this.webRefreshIntervalMillis, (ZonedDateTime)ZonedDateTime.now(), (boolean)false, (boolean)false)));
            fw.flush();
        }
        catch (IOException ioe) {
            LOG.error("Failed to write config file.");
            throw ioe;
        }
    }

    private static String createConfigJson(DashboardConfiguration dashboardConfiguration) throws IOException {
        return OBJECT_MAPPER.writeValueAsString((Object)dashboardConfiguration);
    }

    static class RefreshLocation {
        private final Path path;
        private final FileSystem fs;

        private RefreshLocation(Path path, FileSystem fs) {
            this.path = path;
            this.fs = fs;
        }

        public Path getPath() {
            return this.path;
        }

        public FileSystem getFs() {
            return this.fs;
        }
    }
}

