/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointDeclineReason;
import org.apache.flink.runtime.checkpoint.PendingCheckpoint;
import org.apache.flink.util.Preconditions;

public class CheckpointTriggerResult {
    private final PendingCheckpoint success;
    private final CheckpointDeclineReason failure;

    CheckpointTriggerResult(PendingCheckpoint success) {
        this.success = (PendingCheckpoint)Preconditions.checkNotNull((Object)success);
        this.failure = null;
    }

    CheckpointTriggerResult(CheckpointDeclineReason failure) {
        this.success = null;
        this.failure = (CheckpointDeclineReason)((Object)Preconditions.checkNotNull((Object)((Object)failure)));
    }

    public boolean isSuccess() {
        return this.success != null;
    }

    public boolean isFailure() {
        return this.failure != null;
    }

    public PendingCheckpoint getPendingCheckpoint() {
        if (this.success != null) {
            return this.success;
        }
        throw new IllegalStateException("Checkpoint triggering failed");
    }

    public CheckpointDeclineReason getFailureReason() {
        if (this.failure != null) {
            return this.failure;
        }
        throw new IllegalStateException("Checkpoint triggering was successful");
    }

    public String toString() {
        return "CheckpointTriggerResult(" + (this.isSuccess() ? "success: " + this.success : "failure: " + this.failure.message()) + ")";
    }
}

