/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.hadoop2.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.hadoop2.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Private
public class BlockTokenSecretManager
extends SecretManager<BlockTokenIdentifier> {
    public static final Log LOG = LogFactory.getLog(BlockTokenSecretManager.class);
    private static final int LOW_MASK = Integer.MAX_VALUE;
    public static final Token<BlockTokenIdentifier> DUMMY_TOKEN = new Token();
    private final boolean isMaster;
    private int nnIndex;
    private long keyUpdateInterval;
    private volatile long tokenLifetime;
    private int serialNo;
    private BlockKey currentKey;
    private BlockKey nextKey;
    private final Map<Integer, BlockKey> allKeys;
    private String blockPoolId;
    private final String encryptionAlgorithm;
    private final SecureRandom nonceGenerator = new SecureRandom();
    private Timer timer;

    public BlockTokenSecretManager(long keyUpdateInterval, long tokenLifetime, String blockPoolId, String encryptionAlgorithm) {
        this(false, keyUpdateInterval, tokenLifetime, blockPoolId, encryptionAlgorithm);
    }

    public BlockTokenSecretManager(long keyUpdateInterval, long tokenLifetime, int nnIndex, String blockPoolId, String encryptionAlgorithm) {
        this(true, keyUpdateInterval, tokenLifetime, blockPoolId, encryptionAlgorithm);
        Preconditions.checkArgument(nnIndex == 0 || nnIndex == 1);
        this.nnIndex = nnIndex;
        this.setSerialNo(new SecureRandom().nextInt());
        this.generateKeys();
    }

    private BlockTokenSecretManager(boolean isMaster, long keyUpdateInterval, long tokenLifetime, String blockPoolId, String encryptionAlgorithm) {
        this.isMaster = isMaster;
        this.keyUpdateInterval = keyUpdateInterval;
        this.tokenLifetime = tokenLifetime;
        this.allKeys = new HashMap<Integer, BlockKey>();
        this.blockPoolId = blockPoolId;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.timer = new Timer();
        this.generateKeys();
    }

    @VisibleForTesting
    public synchronized void setSerialNo(int serialNo) {
        this.serialNo = serialNo & Integer.MAX_VALUE | this.nnIndex << 31;
    }

    public void setBlockPoolId(String blockPoolId) {
        this.blockPoolId = blockPoolId;
    }

    private synchronized void generateKeys() {
        if (!this.isMaster) {
            return;
        }
        this.setSerialNo(this.serialNo + 1);
        this.currentKey = new BlockKey(this.serialNo, this.timer.now() + 2L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret());
        this.setSerialNo(this.serialNo + 1);
        this.nextKey = new BlockKey(this.serialNo, this.timer.now() + 3L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret());
        this.allKeys.put(this.currentKey.getKeyId(), this.currentKey);
        this.allKeys.put(this.nextKey.getKeyId(), this.nextKey);
    }

    public synchronized ExportedBlockKeys exportKeys() {
        if (!this.isMaster) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Exporting access keys");
        }
        return new ExportedBlockKeys(true, this.keyUpdateInterval, this.tokenLifetime, this.currentKey, this.allKeys.values().toArray(new BlockKey[0]));
    }

    private synchronized void removeExpiredKeys() {
        long now = this.timer.now();
        Iterator<Map.Entry<Integer, BlockKey>> it = this.allKeys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, BlockKey> e = it.next();
            if (e.getValue().getExpiryDate() >= now) continue;
            it.remove();
        }
    }

    public synchronized void addKeys(ExportedBlockKeys exportedKeys) throws IOException {
        if (this.isMaster || exportedKeys == null) {
            return;
        }
        LOG.info((Object)"Setting block keys");
        this.removeExpiredKeys();
        this.currentKey = exportedKeys.getCurrentKey();
        BlockKey[] receivedKeys = exportedKeys.getAllKeys();
        for (int i = 0; i < receivedKeys.length; ++i) {
            if (receivedKeys[i] == null) continue;
            this.allKeys.put(receivedKeys[i].getKeyId(), receivedKeys[i]);
        }
    }

    public synchronized boolean updateKeys(long updateTime) throws IOException {
        if (updateTime > this.keyUpdateInterval) {
            return this.updateKeys();
        }
        return false;
    }

    synchronized boolean updateKeys() throws IOException {
        if (!this.isMaster) {
            return false;
        }
        LOG.info((Object)"Updating block keys");
        this.removeExpiredKeys();
        this.allKeys.put(this.currentKey.getKeyId(), new BlockKey(this.currentKey.getKeyId(), this.timer.now() + this.keyUpdateInterval + this.tokenLifetime, this.currentKey.getKey()));
        this.currentKey = new BlockKey(this.nextKey.getKeyId(), this.timer.now() + 2L * this.keyUpdateInterval + this.tokenLifetime, this.nextKey.getKey());
        this.allKeys.put(this.currentKey.getKeyId(), this.currentKey);
        this.setSerialNo(this.serialNo + 1);
        this.nextKey = new BlockKey(this.serialNo, this.timer.now() + 3L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret());
        this.allKeys.put(this.nextKey.getKeyId(), this.nextKey);
        return true;
    }

    public Token<BlockTokenIdentifier> generateToken(ExtendedBlock block, EnumSet<AccessMode> modes) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String userID = ugi == null ? null : ugi.getShortUserName();
        return this.generateToken(userID, block, modes);
    }

    public Token<BlockTokenIdentifier> generateToken(String userId, ExtendedBlock block, EnumSet<AccessMode> modes) throws IOException {
        BlockTokenIdentifier id = new BlockTokenIdentifier(userId, block.getBlockPoolId(), block.getBlockId(), modes);
        return new Token<BlockTokenIdentifier>(id, this);
    }

    public void checkAccess(BlockTokenIdentifier id, String userId, ExtendedBlock block, AccessMode mode) throws SecretManager.InvalidToken {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checking access for user=" + userId + ", block=" + block + ", access mode=" + (Object)((Object)mode) + " using " + id.toString()));
        }
        if (userId != null && !userId.equals(id.getUserId())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't belong to user " + userId);
        }
        if (!id.getBlockPoolId().equals(block.getBlockPoolId())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't apply to block " + block);
        }
        if (id.getBlockId() != block.getBlockId()) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't apply to block " + block);
        }
        if (BlockTokenSecretManager.isExpired(id.getExpiryDate())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " is expired.");
        }
        if (!id.getAccessModes().contains((Object)mode)) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't have " + (Object)((Object)mode) + " permission");
        }
    }

    public void checkAccess(Token<BlockTokenIdentifier> token, String userId, ExtendedBlock block, AccessMode mode) throws SecretManager.InvalidToken {
        BlockTokenIdentifier id = new BlockTokenIdentifier();
        try {
            id.readFields(new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        }
        catch (IOException e) {
            throw new SecretManager.InvalidToken("Unable to de-serialize block token identifier for user=" + userId + ", block=" + block + ", access mode=" + (Object)((Object)mode));
        }
        this.checkAccess(id, userId, block, mode);
        if (!Arrays.equals(this.retrievePassword(id), token.getPassword())) {
            throw new SecretManager.InvalidToken("Block token with " + id.toString() + " doesn't have the correct token password");
        }
    }

    private static boolean isExpired(long expiryDate) {
        return Time.now() > expiryDate;
    }

    static boolean isTokenExpired(Token<BlockTokenIdentifier> token) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        long expiryDate = WritableUtils.readVLong(in);
        return BlockTokenSecretManager.isExpired(expiryDate);
    }

    public void setTokenLifetime(long tokenLifetime) {
        this.tokenLifetime = tokenLifetime;
    }

    @Override
    public BlockTokenIdentifier createIdentifier() {
        return new BlockTokenIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] createPassword(BlockTokenIdentifier identifier) {
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.currentKey;
        }
        if (key == null) {
            throw new IllegalStateException("currentKey hasn't been initialized.");
        }
        identifier.setExpiryDate(this.timer.now() + this.tokenLifetime);
        identifier.setKeyId(key.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generating block token for " + identifier.toString()));
        }
        return BlockTokenSecretManager.createPassword(identifier.getBytes(), key.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] retrievePassword(BlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        if (BlockTokenSecretManager.isExpired(identifier.getExpiryDate())) {
            throw new SecretManager.InvalidToken("Block token with " + identifier.toString() + " is expired.");
        }
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.allKeys.get(identifier.getKeyId());
        }
        if (key == null) {
            throw new SecretManager.InvalidToken("Can't re-compute password for " + identifier.toString() + ", since the required block key (keyID=" + identifier.getKeyId() + ") doesn't exist.");
        }
        return BlockTokenSecretManager.createPassword(identifier.getBytes(), key.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataEncryptionKey generateDataEncryptionKey() {
        byte[] nonce = new byte[8];
        this.nonceGenerator.nextBytes(nonce);
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.currentKey;
        }
        byte[] encryptionKey = BlockTokenSecretManager.createPassword(nonce, key.getKey());
        return new DataEncryptionKey(key.getKeyId(), this.blockPoolId, nonce, encryptionKey, this.timer.now() + this.tokenLifetime, this.encryptionAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] retrieveDataEncryptionKey(int keyId, byte[] nonce) throws InvalidEncryptionKeyException {
        BlockKey key = null;
        BlockTokenSecretManager blockTokenSecretManager = this;
        synchronized (blockTokenSecretManager) {
            key = this.allKeys.get(keyId);
            if (key == null) {
                throw new InvalidEncryptionKeyException("Can't re-compute encryption key for nonce, since the required block key (keyID=" + keyId + ") doesn't exist. Current key: " + this.currentKey.getKeyId());
            }
        }
        return BlockTokenSecretManager.createPassword(nonce, key.getKey());
    }

    @VisibleForTesting
    public synchronized void setKeyUpdateIntervalForTesting(long millis) {
        this.keyUpdateInterval = millis;
    }

    @VisibleForTesting
    public void clearAllKeysForTesting() {
        this.allKeys.clear();
    }

    @VisibleForTesting
    public synchronized boolean hasKey(int keyId) {
        BlockKey key = this.allKeys.get(keyId);
        return key != null;
    }

    @VisibleForTesting
    public synchronized int getSerialNoForTesting() {
        return this.serialNo;
    }

    public static enum AccessMode {
        READ,
        WRITE,
        COPY,
        REPLACE;

    }
}

