/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;

public class PathsDeserializer
extends JsonDeserializer<Paths> {
    public Paths deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Paths result = new Paths();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        ObjectNode objectNode = (ObjectNode)node;
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        Iterator it = objectNode.fieldNames();
        while (it.hasNext()) {
            String childName = (String)it.next();
            JsonNode child = objectNode.get(childName);
            if (childName.startsWith("x-")) {
                extensions.put(childName, Json.mapper().convertValue((Object)child, Object.class));
                continue;
            }
            result.put(childName, Json.mapper().convertValue((Object)child, PathItem.class));
        }
        if (!extensions.isEmpty()) {
            result.setExtensions(extensions);
        }
        return result;
    }
}

