/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.handler;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.flink.connector.pulsar.common.config.PulsarConfiguration;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.shade.com.google.common.util.concurrent.RateLimiter;
import org.apache.pulsar.shade.com.google.common.util.concurrent.Uninterruptibles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarAdminInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarAdminInvocationHandler.class);
    private static volatile RateLimiter rateLimiter;
    private final PulsarAdmin admin;
    private final int retryTimes;
    private final long waitMillis;
    private final int requestRates;
    private final Map<String, Object> handlers;

    public PulsarAdminInvocationHandler(PulsarAdmin admin, PulsarConfiguration configuration) {
        this.admin = admin;
        this.retryTimes = (Integer)configuration.get(PulsarOptions.PULSAR_ADMIN_REQUEST_RETRIES);
        this.waitMillis = (Long)configuration.get(PulsarOptions.PULSAR_ADMIN_REQUEST_WAIT_MILLIS);
        this.requestRates = (Integer)configuration.get(PulsarOptions.PULSAR_ADMIN_REQUEST_RATES);
        this.handlers = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE) || !returnType.isInterface()) {
            return method.invoke((Object)this.admin, args);
        }
        String methodName = method.getName();
        if (this.handlers.containsKey(methodName)) {
            return this.handlers.get(methodName);
        }
        Object handler = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{returnType}, (InvocationHandler)new RequestHandler(method.invoke((Object)this.admin, args)));
        this.handlers.put(methodName, handler);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void requestRateLimit(int requestRates) {
        if (rateLimiter == null) {
            Class<PulsarAdminInvocationHandler> clazz = PulsarAdminInvocationHandler.class;
            // MONITORENTER : org.apache.flink.connector.pulsar.common.handler.PulsarAdminInvocationHandler.class
            if (rateLimiter == null) {
                rateLimiter = RateLimiter.create(requestRates);
            }
            // MONITOREXIT : clazz
        }
        rateLimiter.acquire();
    }

    private class RequestHandler
    implements InvocationHandler {
        private final Object handler;

        public RequestHandler(Object handler) {
            this.handler = handler;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.doInvoke(method, args, PulsarAdminInvocationHandler.this.retryTimes);
        }

        private Object doInvoke(Method method, Object[] args, int remainingTimes) throws Throwable {
            while (true) {
                PulsarAdminInvocationHandler.requestRateLimit(PulsarAdminInvocationHandler.this.requestRates);
                try {
                    return method.invoke(this.handler, args);
                }
                catch (InvocationTargetException e) {
                    Throwable throwable = e.getTargetException();
                    if (throwable instanceof PulsarAdminException.NotFoundException) {
                        throw throwable;
                    }
                    if (throwable instanceof PulsarAdminException) {
                        LOG.warn("Request error in Admin API, remain times: {}", (Object)(--remainingTimes), (Object)e);
                        if (remainingTimes == 0) {
                            throw throwable;
                        }
                        Uninterruptibles.sleepUninterruptibly(PulsarAdminInvocationHandler.this.waitMillis, TimeUnit.MILLISECONDS);
                        continue;
                    }
                    throw throwable;
                }
                break;
            }
        }
    }
}

