/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.connector.sink2.Committer;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.TwoPhaseCommittingSink;
import org.apache.flink.connector.pulsar.common.crypto.PulsarCrypto;
import org.apache.flink.connector.pulsar.sink.PulsarSinkBuilder;
import org.apache.flink.connector.pulsar.sink.committer.PulsarCommittable;
import org.apache.flink.connector.pulsar.sink.committer.PulsarCommittableSerializer;
import org.apache.flink.connector.pulsar.sink.committer.PulsarCommitter;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.PulsarWriter;
import org.apache.flink.connector.pulsar.sink.writer.delayer.MessageDelayer;
import org.apache.flink.connector.pulsar.sink.writer.router.KeyHashTopicRouter;
import org.apache.flink.connector.pulsar.sink.writer.router.RoundRobinTopicRouter;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRouter;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRoutingMode;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchema;
import org.apache.flink.connector.pulsar.sink.writer.topic.MetadataListener;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.PulsarClientException;

@PublicEvolving
public class PulsarSink<IN>
implements TwoPhaseCommittingSink<IN, PulsarCommittable> {
    private static final long serialVersionUID = 4416714587951282119L;
    private final SinkConfiguration sinkConfiguration;
    private final PulsarSerializationSchema<IN> serializationSchema;
    private final MetadataListener metadataListener;
    private final TopicRouter<IN> topicRouter;
    private final MessageDelayer<IN> messageDelayer;
    private final PulsarCrypto pulsarCrypto;

    PulsarSink(SinkConfiguration sinkConfiguration, PulsarSerializationSchema<IN> serializationSchema, MetadataListener metadataListener, TopicRoutingMode topicRoutingMode, @Nullable TopicRouter<IN> topicRouter, MessageDelayer<IN> messageDelayer, PulsarCrypto pulsarCrypto) {
        this.sinkConfiguration = (SinkConfiguration)((Object)Preconditions.checkNotNull((Object)((Object)sinkConfiguration)));
        this.serializationSchema = (PulsarSerializationSchema)Preconditions.checkNotNull(serializationSchema);
        this.metadataListener = (MetadataListener)Preconditions.checkNotNull((Object)metadataListener);
        Preconditions.checkNotNull((Object)((Object)topicRoutingMode));
        this.topicRouter = topicRoutingMode == TopicRoutingMode.CUSTOM ? (TopicRouter)Preconditions.checkNotNull(topicRouter) : (topicRoutingMode == TopicRoutingMode.ROUND_ROBIN ? new RoundRobinTopicRouter(sinkConfiguration) : new KeyHashTopicRouter(sinkConfiguration));
        this.messageDelayer = (MessageDelayer)Preconditions.checkNotNull(messageDelayer);
        this.pulsarCrypto = (PulsarCrypto)Preconditions.checkNotNull((Object)pulsarCrypto);
    }

    public static <IN> PulsarSinkBuilder<IN> builder() {
        return new PulsarSinkBuilder();
    }

    @Internal
    public TwoPhaseCommittingSink.PrecommittingSinkWriter<IN, PulsarCommittable> createWriter(Sink.InitContext initContext) throws PulsarClientException {
        return new PulsarWriter<IN>(this.sinkConfiguration, this.serializationSchema, this.metadataListener, this.topicRouter, this.messageDelayer, this.pulsarCrypto, initContext);
    }

    @Internal
    public Committer<PulsarCommittable> createCommitter() {
        return new PulsarCommitter(this.sinkConfiguration);
    }

    @Internal
    public SimpleVersionedSerializer<PulsarCommittable> getCommittableSerializer() {
        return new PulsarCommittableSerializer();
    }
}

