/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigBuilder;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.common.crypto.PulsarCrypto;
import org.apache.flink.connector.pulsar.sink.PulsarSink;
import org.apache.flink.connector.pulsar.sink.PulsarSinkOptions;
import org.apache.flink.connector.pulsar.sink.config.PulsarSinkConfigUtils;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.flink.connector.pulsar.sink.writer.delayer.MessageDelayer;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRouter;
import org.apache.flink.connector.pulsar.sink.writer.router.TopicRoutingMode;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSchemaWrapper;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchema;
import org.apache.flink.connector.pulsar.sink.writer.serializer.PulsarSerializationSchemaWrapper;
import org.apache.flink.connector.pulsar.sink.writer.topic.MetadataListener;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class PulsarSinkBuilder<IN> {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarSinkBuilder.class);
    private final PulsarConfigBuilder configBuilder = new PulsarConfigBuilder();
    private PulsarSerializationSchema<IN> serializationSchema;
    private MetadataListener metadataListener;
    private TopicRoutingMode topicRoutingMode;
    private TopicRouter<IN> topicRouter;
    private MessageDelayer<IN> messageDelayer;
    private PulsarCrypto pulsarCrypto;

    PulsarSinkBuilder() {
    }

    public PulsarSinkBuilder<IN> setAdminUrl(String adminUrl) {
        return this.setConfig(PulsarOptions.PULSAR_ADMIN_URL, adminUrl);
    }

    public PulsarSinkBuilder<IN> setServiceUrl(String serviceUrl) {
        return this.setConfig(PulsarOptions.PULSAR_SERVICE_URL, serviceUrl);
    }

    public PulsarSinkBuilder<IN> setProducerName(String producerName) {
        return this.setConfig(PulsarSinkOptions.PULSAR_PRODUCER_NAME, producerName);
    }

    public PulsarSinkBuilder<IN> setTopics(String ... topics) {
        return this.setTopics(Arrays.asList(topics));
    }

    public PulsarSinkBuilder<IN> setTopics(List<String> topics) {
        Preconditions.checkState((this.metadataListener == null ? 1 : 0) != 0, (Object)"setTopics couldn't be set twice.");
        List<String> topicSet = TopicNameUtils.distinctTopics(topics);
        this.metadataListener = new MetadataListener(topicSet);
        return this;
    }

    public PulsarSinkBuilder<IN> setDeliveryGuarantee(DeliveryGuarantee deliveryGuarantee) {
        Preconditions.checkNotNull((Object)((Object)deliveryGuarantee), (String)"deliveryGuarantee");
        this.configBuilder.override(PulsarSinkOptions.PULSAR_WRITE_DELIVERY_GUARANTEE, deliveryGuarantee);
        return this;
    }

    public PulsarSinkBuilder<IN> setTopicRoutingMode(TopicRoutingMode topicRoutingMode) {
        Preconditions.checkArgument((topicRoutingMode != TopicRoutingMode.CUSTOM ? 1 : 0) != 0, (Object)"CUSTOM mode should be set by using setTopicRouter method.");
        this.topicRoutingMode = (TopicRoutingMode)((Object)Preconditions.checkNotNull((Object)((Object)topicRoutingMode), (String)"topicRoutingMode"));
        return this;
    }

    public PulsarSinkBuilder<IN> setTopicRouter(TopicRouter<IN> topicRouter) {
        if (this.topicRoutingMode != null && this.topicRoutingMode != TopicRoutingMode.CUSTOM) {
            LOG.warn("We would override topicRoutingMode to CUSTOM if you provide TopicRouter.");
        }
        this.topicRoutingMode = TopicRoutingMode.CUSTOM;
        this.topicRouter = (TopicRouter)Preconditions.checkNotNull(topicRouter, (String)"topicRouter");
        return this;
    }

    public <T extends IN> PulsarSinkBuilder<T> setSerializationSchema(SerializationSchema<T> serializationSchema) {
        return this.setSerializationSchema(new PulsarSerializationSchemaWrapper<T>(serializationSchema));
    }

    public <T extends IN> PulsarSinkBuilder<T> setSerializationSchema(Schema<T> schema) {
        return this.setSerializationSchema(new PulsarSchemaWrapper<T>(schema));
    }

    public <T extends IN> PulsarSinkBuilder<T> setSerializationSchema(Schema<T> schema, Class<T> typeClass) {
        return this.setSerializationSchema(new PulsarSchemaWrapper<T>(schema, typeClass));
    }

    public <K, V, T extends IN> PulsarSinkBuilder<T> setSerializationSchema(Schema<KeyValue<K, V>> schema, Class<K> keyClass, Class<V> valueClass) {
        return this.setSerializationSchema(new PulsarSchemaWrapper(schema, keyClass, valueClass));
    }

    public <T extends IN> PulsarSinkBuilder<T> setSerializationSchema(PulsarSerializationSchema<T> serializationSchema) {
        PulsarSinkBuilder<T> self = this.specialized();
        self.serializationSchema = serializationSchema;
        return self;
    }

    public PulsarSinkBuilder<IN> enableSchemaEvolution() {
        this.configBuilder.override(PulsarSinkOptions.PULSAR_WRITE_SCHEMA_EVOLUTION, true);
        return this;
    }

    public PulsarSinkBuilder<IN> delaySendingMessage(MessageDelayer<IN> messageDelayer) {
        this.messageDelayer = (MessageDelayer)Preconditions.checkNotNull(messageDelayer);
        return this;
    }

    public PulsarSinkBuilder<IN> setPulsarCrypto(PulsarCrypto pulsarCrypto, ProducerCryptoFailureAction action) {
        this.pulsarCrypto = (PulsarCrypto)Preconditions.checkNotNull((Object)pulsarCrypto);
        this.configBuilder.set(PulsarSinkOptions.PULSAR_PRODUCER_CRYPTO_FAILURE_ACTION, action);
        return this;
    }

    public PulsarSinkBuilder<IN> setAuthentication(String authPluginClassName, String authParamsString) {
        this.configBuilder.set(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME, authPluginClassName);
        this.configBuilder.set(PulsarOptions.PULSAR_AUTH_PARAMS, authParamsString);
        return this;
    }

    public PulsarSinkBuilder<IN> setAuthentication(String authPluginClassName, Map<String, String> authParams) {
        this.configBuilder.set(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME, authPluginClassName);
        this.configBuilder.set(PulsarOptions.PULSAR_AUTH_PARAM_MAP, authParams);
        return this;
    }

    public <T> PulsarSinkBuilder<IN> setConfig(ConfigOption<T> key, T value) {
        this.configBuilder.set(key, value);
        return this;
    }

    public PulsarSinkBuilder<IN> setConfig(Configuration config) {
        this.configBuilder.set(config);
        return this;
    }

    public PulsarSinkBuilder<IN> setProperties(Properties properties) {
        this.configBuilder.set(properties);
        return this;
    }

    public PulsarSink<IN> build() {
        DeliveryGuarantee deliveryGuarantee = this.configBuilder.get(PulsarSinkOptions.PULSAR_WRITE_DELIVERY_GUARANTEE);
        if (deliveryGuarantee == DeliveryGuarantee.NONE) {
            LOG.warn("You haven't set delivery guarantee or set it to NONE, this would cause data loss. Make sure you have known this shortcoming.");
        } else if (deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
            LOG.info("Exactly once require flink checkpoint and your pulsar cluster should support the transaction.");
            this.configBuilder.override(PulsarOptions.PULSAR_ENABLE_TRANSACTION, true);
            this.configBuilder.override(PulsarSinkOptions.PULSAR_SEND_TIMEOUT_MS, 0L);
            if (!this.configBuilder.contains(PulsarSinkOptions.PULSAR_WRITE_TRANSACTION_TIMEOUT)) {
                LOG.warn("The default pulsar transaction timeout is 3 hours, make sure it was greater than your checkpoint interval.");
            } else {
                Long timeout = this.configBuilder.get(PulsarSinkOptions.PULSAR_WRITE_TRANSACTION_TIMEOUT);
                LOG.warn("The configured transaction timeout is {} mille seconds, make sure it was greater than your checkpoint interval.", (Object)timeout);
            }
        }
        if (!this.configBuilder.contains(PulsarSinkOptions.PULSAR_PRODUCER_NAME)) {
            LOG.warn("We recommend set a readable producer name through setProducerName(String) in production mode.");
        } else {
            String producerName = this.configBuilder.get(PulsarSinkOptions.PULSAR_PRODUCER_NAME);
            if (!producerName.contains("%s")) {
                this.configBuilder.override(PulsarSinkOptions.PULSAR_PRODUCER_NAME, producerName + " - %s");
            }
        }
        Preconditions.checkNotNull(this.serializationSchema, (String)"serializationSchema must be set.");
        if (Boolean.TRUE.equals(this.configBuilder.get(PulsarSinkOptions.PULSAR_WRITE_SCHEMA_EVOLUTION))) {
            Preconditions.checkState((boolean)(this.serializationSchema instanceof PulsarSchemaWrapper), (Object)"When enabling schema evolution, you must provide a Pulsar Schema in builder's setSerializationSchema method.");
        } else if (this.serializationSchema instanceof PulsarSchemaWrapper) {
            LOG.info("It seems like you are sending messages by using Pulsar Schema. You can builder.enableSchemaEvolution() to enable schema evolution for better Pulsar Schema check. We would use bypass Schema check by default.");
        }
        if (this.metadataListener == null) {
            if (this.topicRouter == null) {
                throw new NullPointerException("No topic names or custom topic router are provided.");
            }
            LOG.warn("No topic set has been provided, make sure your custom topic router support empty topic set.");
            this.metadataListener = new MetadataListener();
        }
        if (this.topicRoutingMode == null) {
            LOG.info("No topic routing mode has been chosen. We use round-robin mode as default.");
            this.topicRoutingMode = TopicRoutingMode.ROUND_ROBIN;
        }
        if (this.messageDelayer == null) {
            this.messageDelayer = MessageDelayer.never();
        }
        if (this.pulsarCrypto == null) {
            this.pulsarCrypto = PulsarCrypto.disabled();
        }
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable(this.serializationSchema), (Object)"PulsarSerializationSchema isn't serializable");
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable(this.messageDelayer), (Object)"MessageDelayer isn't serializable");
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable((Object)this.pulsarCrypto), (Object)"PulsarCrypto isn't serializable");
        SinkConfiguration sinkConfiguration = this.configBuilder.build(PulsarSinkConfigUtils.SINK_CONFIG_VALIDATOR, SinkConfiguration::new);
        return new PulsarSink<IN>(sinkConfiguration, this.serializationSchema, this.metadataListener, this.topicRoutingMode, this.topicRouter, this.messageDelayer, this.pulsarCrypto);
    }

    private <T extends IN> PulsarSinkBuilder<T> specialized() {
        return this;
    }
}

