/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigBuilder;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.common.crypto.PulsarCrypto;
import org.apache.flink.connector.pulsar.source.PulsarSource;
import org.apache.flink.connector.pulsar.source.PulsarSourceOptions;
import org.apache.flink.connector.pulsar.source.config.PulsarSourceConfigUtils;
import org.apache.flink.connector.pulsar.source.config.SourceConfiguration;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StartCursor;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.PulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.FullRangeGenerator;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.connector.pulsar.source.reader.deserializer.GenericRecordDeserializationSchema;
import org.apache.flink.connector.pulsar.source.reader.deserializer.GenericRecordDeserializer;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchema;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarDeserializationSchemaWrapper;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarSchemaWrapper;
import org.apache.flink.connector.pulsar.source.reader.deserializer.PulsarTypeInformationWrapper;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public final class PulsarSourceBuilder<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarSourceBuilder.class);
    private final PulsarConfigBuilder configBuilder = new PulsarConfigBuilder();
    private PulsarSubscriber subscriber;
    private RangeGenerator rangeGenerator;
    private StartCursor startCursor = StartCursor.defaultStartCursor();
    private StopCursor stopCursor = StopCursor.defaultStopCursor();
    private Boundedness boundedness = Boundedness.CONTINUOUS_UNBOUNDED;
    private PulsarDeserializationSchema<OUT> deserializationSchema;
    private PulsarCrypto pulsarCrypto;

    PulsarSourceBuilder() {
    }

    public PulsarSourceBuilder<OUT> setAdminUrl(String adminUrl) {
        return this.setConfig(PulsarOptions.PULSAR_ADMIN_URL, adminUrl);
    }

    public PulsarSourceBuilder<OUT> setServiceUrl(String serviceUrl) {
        return this.setConfig(PulsarOptions.PULSAR_SERVICE_URL, serviceUrl);
    }

    public PulsarSourceBuilder<OUT> setSubscriptionName(String subscriptionName) {
        return this.setConfig(PulsarSourceOptions.PULSAR_SUBSCRIPTION_NAME, subscriptionName);
    }

    public PulsarSourceBuilder<OUT> setTopics(String ... topics) {
        return this.setTopics(Arrays.asList(topics));
    }

    public PulsarSourceBuilder<OUT> setTopics(List<String> topics) {
        this.ensureSubscriberIsNull("topics");
        List<String> distinctTopics = TopicNameUtils.distinctTopics(topics);
        this.subscriber = PulsarSubscriber.getTopicListSubscriber(distinctTopics);
        return this;
    }

    public PulsarSourceBuilder<OUT> setTopicPattern(String topicsPattern) {
        return this.setTopicPattern(Pattern.compile(topicsPattern));
    }

    public PulsarSourceBuilder<OUT> setTopicPattern(Pattern topicsPattern) {
        return this.setTopicPattern(topicsPattern, RegexSubscriptionMode.AllTopics);
    }

    public PulsarSourceBuilder<OUT> setTopicPattern(String topicsPattern, RegexSubscriptionMode regexSubscriptionMode) {
        return this.setTopicPattern(Pattern.compile(topicsPattern), regexSubscriptionMode);
    }

    public PulsarSourceBuilder<OUT> setTopicPattern(Pattern topicsPattern, RegexSubscriptionMode regexSubscriptionMode) {
        this.ensureSubscriberIsNull("topic pattern");
        this.subscriber = PulsarSubscriber.getTopicPatternSubscriber(topicsPattern, regexSubscriptionMode);
        return this;
    }

    public PulsarSourceBuilder<OUT> setConsumerName(String consumerName) {
        return this.setConfig(PulsarSourceOptions.PULSAR_CONSUMER_NAME, consumerName);
    }

    public PulsarSourceBuilder<OUT> enableSchemaEvolution() {
        this.configBuilder.set(PulsarSourceOptions.PULSAR_READ_SCHEMA_EVOLUTION, true);
        return this;
    }

    public PulsarSourceBuilder<OUT> setRangeGenerator(RangeGenerator rangeGenerator) {
        this.rangeGenerator = (RangeGenerator)Preconditions.checkNotNull((Object)rangeGenerator);
        return this;
    }

    public PulsarSourceBuilder<OUT> setStartCursor(StartCursor startCursor) {
        this.startCursor = (StartCursor)Preconditions.checkNotNull((Object)startCursor);
        return this;
    }

    public PulsarSourceBuilder<OUT> setUnboundedStopCursor(StopCursor stopCursor) {
        this.boundedness = Boundedness.CONTINUOUS_UNBOUNDED;
        this.stopCursor = (StopCursor)Preconditions.checkNotNull((Object)stopCursor);
        return this;
    }

    public PulsarSourceBuilder<OUT> setBoundedStopCursor(StopCursor stopCursor) {
        this.boundedness = Boundedness.BOUNDED;
        this.stopCursor = (StopCursor)Preconditions.checkNotNull((Object)stopCursor);
        return this;
    }

    public <T extends OUT> PulsarSourceBuilder<T> setDeserializationSchema(DeserializationSchema<T> deserializationSchema) {
        return this.setDeserializationSchema(new PulsarDeserializationSchemaWrapper<T>(deserializationSchema));
    }

    public <T extends OUT> PulsarSourceBuilder<T> setDeserializationSchema(GenericRecordDeserializer<T> deserializer) {
        return this.setDeserializationSchema(new GenericRecordDeserializationSchema<T>(deserializer));
    }

    public <T extends OUT> PulsarSourceBuilder<T> setDeserializationSchema(Schema<T> schema) {
        this.ensureSchemaTypeIsValid(schema);
        return this.setDeserializationSchema(new PulsarSchemaWrapper<T>(schema));
    }

    public <T extends OUT> PulsarSourceBuilder<T> setDeserializationSchema(Schema<T> schema, Class<T> typeClass) {
        this.ensureSchemaTypeIsValid(schema);
        return this.setDeserializationSchema(new PulsarSchemaWrapper<T>(schema, typeClass));
    }

    public <K, V, T extends OUT> PulsarSourceBuilder<T> setDeserializationSchema(Schema<KeyValue<K, V>> schema, Class<K> keyClass, Class<V> valueClass) {
        this.ensureSchemaTypeIsValid(schema);
        return this.setDeserializationSchema(new PulsarSchemaWrapper(schema, keyClass, valueClass));
    }

    public <T extends OUT> PulsarSourceBuilder<T> setDeserializationSchema(TypeInformation<T> information, ExecutionConfig config) {
        return this.setDeserializationSchema(new PulsarTypeInformationWrapper<T>(information, config));
    }

    public <T extends OUT> PulsarSourceBuilder<T> setDeserializationSchema(PulsarDeserializationSchema<T> deserializationSchema) {
        PulsarSourceBuilder<T> self = this.specialized();
        self.deserializationSchema = deserializationSchema;
        return self;
    }

    public PulsarSourceBuilder<OUT> setPulsarCrypto(PulsarCrypto pulsarCrypto, ConsumerCryptoFailureAction action) {
        this.pulsarCrypto = (PulsarCrypto)Preconditions.checkNotNull((Object)pulsarCrypto);
        this.configBuilder.set(PulsarSourceOptions.PULSAR_CRYPTO_FAILURE_ACTION, action);
        return this;
    }

    public PulsarSourceBuilder<OUT> setAuthentication(String authPluginClassName, String authParamsString) {
        Preconditions.checkArgument((!this.configBuilder.contains(PulsarOptions.PULSAR_AUTH_PARAM_MAP) ? 1 : 0) != 0, (Object)"Duplicated authentication setting.");
        this.configBuilder.set(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME, authPluginClassName);
        this.configBuilder.set(PulsarOptions.PULSAR_AUTH_PARAMS, authParamsString);
        return this;
    }

    public PulsarSourceBuilder<OUT> setAuthentication(String authPluginClassName, Map<String, String> authParams) {
        Preconditions.checkArgument((!this.configBuilder.contains(PulsarOptions.PULSAR_AUTH_PARAMS) ? 1 : 0) != 0, (Object)"Duplicated authentication setting.");
        this.configBuilder.set(PulsarOptions.PULSAR_AUTH_PLUGIN_CLASS_NAME, authPluginClassName);
        this.configBuilder.set(PulsarOptions.PULSAR_AUTH_PARAM_MAP, authParams);
        return this;
    }

    public <T> PulsarSourceBuilder<OUT> setConfig(ConfigOption<T> key, T value) {
        this.configBuilder.set(key, value);
        return this;
    }

    public PulsarSourceBuilder<OUT> setConfig(Configuration config) {
        this.configBuilder.set(config);
        return this;
    }

    public PulsarSourceBuilder<OUT> setProperties(Properties properties) {
        this.configBuilder.set(properties);
        return this;
    }

    public PulsarSource<OUT> build() {
        Preconditions.checkNotNull((Object)this.subscriber, (String)"No topic names or topic pattern are provided.");
        if (this.rangeGenerator == null) {
            LOG.warn("No range generator provided, we would use the FullRangeGenerator as the default range generator.");
            this.rangeGenerator = new FullRangeGenerator();
        }
        if (this.boundedness == null) {
            LOG.warn("No boundedness was set, mark it as a endless stream.");
            this.boundedness = Boundedness.CONTINUOUS_UNBOUNDED;
        }
        if (this.boundedness == Boundedness.BOUNDED && this.configBuilder.get(PulsarSourceOptions.PULSAR_PARTITION_DISCOVERY_INTERVAL_MS) >= 0L) {
            LOG.warn("{} property is overridden to -1 because the source is bounded.", PulsarSourceOptions.PULSAR_PARTITION_DISCOVERY_INTERVAL_MS);
            this.configBuilder.override(PulsarSourceOptions.PULSAR_PARTITION_DISCOVERY_INTERVAL_MS, -1L);
        }
        Preconditions.checkNotNull(this.deserializationSchema, (String)"deserializationSchema should be set.");
        if (Boolean.TRUE.equals(this.configBuilder.get(PulsarSourceOptions.PULSAR_READ_SCHEMA_EVOLUTION))) {
            Preconditions.checkState((boolean)(this.deserializationSchema instanceof PulsarSchemaWrapper), (Object)"When enabling schema evolution, you must provide a Pulsar Schema in builder's setDeserializationSchema method.");
        } else if (this.deserializationSchema instanceof PulsarSchemaWrapper) {
            LOG.info("It seems like you are consuming messages by using Pulsar Schema. You can builder.enableSchemaEvolution() to enable schema evolution for better Pulsar Schema check. We would use bypass Schema check by default.");
        }
        if (this.pulsarCrypto == null) {
            this.pulsarCrypto = PulsarCrypto.disabled();
        }
        if (!this.configBuilder.contains(PulsarSourceOptions.PULSAR_CONSUMER_NAME)) {
            LOG.warn("We recommend set a readable consumer name through setConsumerName(String) in production mode.");
        } else {
            String consumerName = this.configBuilder.get(PulsarSourceOptions.PULSAR_CONSUMER_NAME);
            if (!consumerName.contains("%s")) {
                this.configBuilder.override(PulsarSourceOptions.PULSAR_CONSUMER_NAME, consumerName + " - %s");
            }
        }
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable(this.deserializationSchema), (Object)"PulsarDeserializationSchema isn't serializable");
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable((Object)this.startCursor), (Object)"StartCursor isn't serializable");
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable((Object)this.stopCursor), (Object)"StopCursor isn't serializable");
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable((Object)this.rangeGenerator), (Object)"RangeGenerator isn't serializable");
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable((Object)this.pulsarCrypto), (Object)"PulsarCrypto isn't serializable");
        SourceConfiguration sourceConfiguration = this.configBuilder.build(PulsarSourceConfigUtils.SOURCE_CONFIG_VALIDATOR, SourceConfiguration::new);
        return new PulsarSource<OUT>(sourceConfiguration, this.subscriber, this.rangeGenerator, this.startCursor, this.stopCursor, this.boundedness, this.deserializationSchema, this.pulsarCrypto);
    }

    private <T extends OUT> PulsarSourceBuilder<T> specialized() {
        return this;
    }

    private void ensureSubscriberIsNull(String attemptingSubscribeMode) {
        if (this.subscriber != null) {
            throw new IllegalStateException(String.format("Cannot use %s for consumption because a %s is already set for consumption", attemptingSubscribeMode, this.subscriber.getClass().getSimpleName()));
        }
    }

    private void ensureSchemaTypeIsValid(Schema<?> schema) {
        SchemaInfo info = schema.getSchemaInfo();
        if (info.getType() == SchemaType.AUTO_CONSUME) {
            throw new IllegalArgumentException("Auto schema is only supported by providing a GenericRecordDeserializer");
        }
        if (info.getType() == SchemaType.AUTO_PUBLISH) {
            throw new IllegalStateException("Auto produce schema is not supported in consuming messages");
        }
    }
}

