/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.assigner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumState;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;

class SplitAssignerImpl
implements SplitAssigner {
    private final StopCursor stopCursor;
    private final boolean enablePartitionDiscovery;
    private final SplitEnumeratorContext<PulsarPartitionSplit> context;
    private final Set<TopicPartition> appendedPartitions;
    private final Map<Integer, Set<PulsarPartitionSplit>> pendingPartitionSplits;
    private boolean initialized;

    SplitAssignerImpl(StopCursor stopCursor, boolean enablePartitionDiscovery, SplitEnumeratorContext<PulsarPartitionSplit> context, PulsarSourceEnumState enumState) {
        this.stopCursor = stopCursor;
        this.enablePartitionDiscovery = enablePartitionDiscovery;
        this.context = context;
        this.appendedPartitions = enumState.getAppendedPartitions();
        this.pendingPartitionSplits = new HashMap<Integer, Set<PulsarPartitionSplit>>(context.currentParallelism());
        this.initialized = false;
    }

    @Override
    public List<TopicPartition> registerTopicPartitions(Set<TopicPartition> fetchedPartitions) {
        ArrayList<TopicPartition> newPartitions = new ArrayList<TopicPartition>();
        for (TopicPartition partition : fetchedPartitions) {
            if (this.appendedPartitions.contains(partition)) continue;
            this.appendedPartitions.add(partition);
            newPartitions.add(partition);
            int readerId = this.partitionOwner(partition);
            PulsarPartitionSplit split = new PulsarPartitionSplit(partition, this.stopCursor);
            this.addSplitToPendingList(readerId, split);
        }
        if (!this.initialized) {
            this.initialized = true;
        }
        return newPartitions;
    }

    @Override
    public void addSplitsBack(List<PulsarPartitionSplit> splits, int subtaskId) {
        for (PulsarPartitionSplit split : splits) {
            int readerId = this.partitionOwner(split.getPartition());
            this.addSplitToPendingList(readerId, split);
        }
    }

    @Override
    public Optional<SplitsAssignment<PulsarPartitionSplit>> createAssignment(List<Integer> readers) {
        if (this.pendingPartitionSplits.isEmpty() || readers.isEmpty()) {
            return Optional.empty();
        }
        HashMap<Integer, ArrayList<PulsarPartitionSplit>> assignMap = new HashMap<Integer, ArrayList<PulsarPartitionSplit>>(this.pendingPartitionSplits.size());
        for (Integer reader : readers) {
            Set<PulsarPartitionSplit> splits = this.pendingPartitionSplits.remove(reader);
            if (splits == null || splits.isEmpty()) continue;
            assignMap.put(reader, new ArrayList<PulsarPartitionSplit>(splits));
        }
        if (assignMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new SplitsAssignment(assignMap));
    }

    @Override
    public boolean noMoreSplits(Integer reader) {
        return !this.enablePartitionDiscovery && this.initialized && !this.pendingPartitionSplits.containsKey(reader);
    }

    @Override
    public PulsarSourceEnumState snapshotState() {
        return new PulsarSourceEnumState(this.appendedPartitions);
    }

    @Override
    public long getUnassignedSplitCount() {
        return this.pendingPartitionSplits.values().stream().mapToLong(Set::size).sum();
    }

    private void addSplitToPendingList(int readerId, PulsarPartitionSplit split) {
        Set splits = this.pendingPartitionSplits.computeIfAbsent(readerId, i -> new HashSet());
        splits.add(split);
    }

    private int partitionOwner(TopicPartition partition) {
        return SplitAssignerImpl.calculatePartitionOwner(partition.getTopic(), partition.getPartitionId(), this.context.currentParallelism());
    }

    @VisibleForTesting
    static int calculatePartitionOwner(String topic, int partitionId, int parallelism) {
        int startIndex = (topic.hashCode() * 31 & Integer.MAX_VALUE) % parallelism;
        return (startIndex + partitionId) % parallelism;
    }
}

