/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor.stop;

import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;

public class MessageIdStopCursor
implements StopCursor {
    private static final long serialVersionUID = -3990454110809274542L;
    private final MessageId messageId;
    private final boolean inclusive;

    public MessageIdStopCursor(MessageId messageId, boolean inclusive) {
        Preconditions.checkArgument((!MessageId.earliest.equals(messageId) ? 1 : 0) != 0, (Object)"MessageId.earliest is not supported.");
        Preconditions.checkArgument((!MessageId.latest.equals(messageId) ? 1 : 0) != 0, (Object)"Use LatestMessageStopCursor instead.");
        this.messageId = MessageIdImpl.convertToMessageIdImpl(messageId);
        this.inclusive = inclusive;
    }

    @Override
    public StopCursor.StopCondition shouldStop(Message<?> message) {
        MessageId current = message.getMessageId();
        return StopCursor.StopCondition.compare(this.messageId, current, this.inclusive);
    }
}

