/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class TopicPartition
implements Serializable {
    private static final long serialVersionUID = -1474354741550810953L;
    private static final Logger LOG = LoggerFactory.getLogger(TopicPartition.class);
    public static final int NON_PARTITION_ID = -1;
    private static final List<TopicRange> FULL_RANGES = ImmutableList.of(TopicRange.createFullRange());
    private final String topic;
    private final int partitionId;
    private final List<TopicRange> ranges;

    @PublicEvolving
    public TopicPartition(String topic) {
        TopicName topicName = TopicName.get(topic);
        this.topic = topicName.getPartitionedTopicName();
        this.partitionId = topicName.isPartitioned() ? topicName.getPartitionIndex() : -1;
        this.ranges = FULL_RANGES;
    }

    @PublicEvolving
    public TopicPartition(String topic, int partitionId) {
        this(topic, partitionId, FULL_RANGES);
    }

    @Internal
    public TopicPartition(String topic, List<TopicRange> ranges) {
        this(topic, -1, ranges);
    }

    @Internal
    public TopicPartition(String topic, int partitionId, List<TopicRange> ranges) {
        Preconditions.checkArgument((partitionId >= -1 ? 1 : 0) != 0, (Object)"Invalid partition id.");
        TopicName topicName = TopicName.get(topic);
        this.topic = topicName.getPartitionedTopicName();
        if (partitionId == -1 && topicName.isPartitioned()) {
            LOG.warn("Invalid non partition id, this topic {} is a partitioned topic", (Object)topic);
            this.partitionId = topicName.getPartitionIndex();
        } else {
            this.partitionId = partitionId;
        }
        this.ranges = (List)Preconditions.checkNotNull(ranges);
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public boolean isPartition() {
        return this.partitionId != -1;
    }

    public String getFullTopicName() {
        if (this.isPartition()) {
            return TopicNameUtils.topicNameWithPartition(this.topic, this.partitionId);
        }
        return this.topic;
    }

    @Internal
    public List<TopicRange> getRanges() {
        return this.ranges;
    }

    @Internal
    public List<Range> getPulsarRanges() {
        return this.ranges.stream().map(TopicRange::toPulsarRange).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartition partition = (TopicPartition)o;
        return this.partitionId == partition.partitionId && this.topic.equals(partition.topic) && this.ranges.equals(partition.ranges);
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.partitionId, this.ranges);
    }

    public String toString() {
        return this.getFullTopicName() + "|" + this.ranges;
    }
}

