/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.binary;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.binary.BinarySection;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.binary.LazyBinaryFormat;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.InstantiationUtil;

@Internal
public final class BinaryRawValueData<T>
extends LazyBinaryFormat<T>
implements RawValueData<T> {
    public BinaryRawValueData(T javaObject) {
        super(javaObject);
    }

    public BinaryRawValueData(MemorySegment[] segments, int offset, int sizeInBytes) {
        super(segments, offset, sizeInBytes);
    }

    public BinaryRawValueData(MemorySegment[] segments, int offset, int sizeInBytes, T javaObject) {
        super(segments, offset, sizeInBytes, javaObject);
    }

    @Override
    public T toObject(TypeSerializer<T> serializer) {
        if (this.javaObject == null) {
            try {
                this.javaObject = InstantiationUtil.deserializeFromByteArray(serializer, (byte[])this.toBytes(serializer));
            }
            catch (IOException e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
        }
        return (T)this.javaObject;
    }

    @Override
    public byte[] toBytes(TypeSerializer<T> serializer) {
        this.ensureMaterialized(serializer);
        return BinarySegmentUtils.copyToBytes(this.getSegments(), this.getOffset(), this.getSizeInBytes());
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("BinaryRawValueData cannot be compared");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("BinaryRawValueData does not have a hashCode");
    }

    public String toString() {
        return String.format("SqlRawValue{%s}", this.javaObject == null ? "?" : this.javaObject);
    }

    @Override
    protected BinarySection materialize(TypeSerializer<T> serializer) {
        try {
            byte[] bytes = InstantiationUtil.serializeToByteArray(serializer, (Object)this.javaObject);
            return new BinarySection(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> BinaryRawValueData<T> fromObject(T javaObject) {
        if (javaObject == null) {
            return null;
        }
        return new BinaryRawValueData<T>(javaObject);
    }

    public static <T> BinaryRawValueData<T> fromBytes(byte[] bytes) {
        return BinaryRawValueData.fromBytes(bytes, 0, bytes.length);
    }

    public static <T> BinaryRawValueData<T> fromBytes(byte[] bytes, int offset, int numBytes) {
        return new BinaryRawValueData<T>(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, offset, numBytes);
    }
}

