/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.FunctionHint;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.extraction.DataTypeTemplate;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionArgumentTemplate;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;

@Internal
final class FunctionTemplate {
    private static final FunctionHint DEFAULT_ANNOTATION = FunctionTemplate.getDefaultAnnotation();
    @Nullable
    private final FunctionSignatureTemplate signatureTemplate;
    @Nullable
    private final FunctionResultTemplate accumulatorTemplate;
    @Nullable
    private final FunctionResultTemplate outputTemplate;

    private FunctionTemplate(@Nullable FunctionSignatureTemplate signatureTemplate, @Nullable FunctionResultTemplate accumulatorTemplate, @Nullable FunctionResultTemplate outputTemplate) {
        this.signatureTemplate = signatureTemplate;
        this.accumulatorTemplate = accumulatorTemplate;
        this.outputTemplate = outputTemplate;
    }

    static FunctionTemplate fromAnnotation(DataTypeFactory typeFactory, FunctionHint hint) {
        return new FunctionTemplate(FunctionTemplate.createSignatureTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, FunctionHint::input), FunctionTemplate.defaultAsNull(hint, FunctionHint::argumentNames), hint.isVarArgs()), FunctionTemplate.createResultTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, FunctionHint::accumulator)), FunctionTemplate.createResultTemplate(typeFactory, FunctionTemplate.defaultAsNull(hint, FunctionHint::output)));
    }

    @Nullable
    FunctionSignatureTemplate getSignatureTemplate() {
        return this.signatureTemplate;
    }

    @Nullable
    FunctionResultTemplate getAccumulatorTemplate() {
        return this.accumulatorTemplate;
    }

    @Nullable
    FunctionResultTemplate getOutputTemplate() {
        return this.outputTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionTemplate template = (FunctionTemplate)o;
        return Objects.equals(this.signatureTemplate, template.signatureTemplate) && Objects.equals(this.accumulatorTemplate, template.accumulatorTemplate) && Objects.equals(this.outputTemplate, template.outputTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.signatureTemplate, this.accumulatorTemplate, this.outputTemplate);
    }

    private static FunctionHint getDefaultAnnotation() {
        return DefaultAnnotationHelper.class.getAnnotation(FunctionHint.class);
    }

    private static <T> T defaultAsNull(FunctionHint hint, Function<FunctionHint, T> accessor) {
        T actualValue;
        T defaultValue = accessor.apply(DEFAULT_ANNOTATION);
        if (Objects.deepEquals(defaultValue, actualValue = accessor.apply(hint))) {
            return null;
        }
        return actualValue;
    }

    @Nullable
    private static FunctionSignatureTemplate createSignatureTemplate(DataTypeFactory typeFactory, @Nullable DataTypeHint[] input, @Nullable String[] argumentNames, boolean isVarArg) {
        if (input == null) {
            return null;
        }
        return FunctionSignatureTemplate.of(Arrays.stream(input).map(dataTypeHint -> FunctionTemplate.createArgumentTemplate(typeFactory, dataTypeHint)).collect(Collectors.toList()), isVarArg, argumentNames);
    }

    @Nullable
    private static FunctionResultTemplate createResultTemplate(DataTypeFactory typeFactory, @Nullable DataTypeHint hint) {
        DataTypeTemplate template;
        if (hint == null) {
            return null;
        }
        try {
            template = DataTypeTemplate.fromAnnotation(typeFactory, hint);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Error in data type hint annotation.", new Object[0]);
        }
        if (template.dataType != null) {
            return FunctionResultTemplate.of(template.dataType);
        }
        throw ExtractionUtils.extractionError("Data type hint does not specify a data type for use as function result.", new Object[0]);
    }

    private static FunctionArgumentTemplate createArgumentTemplate(DataTypeFactory typeFactory, DataTypeHint hint) {
        DataTypeTemplate template = DataTypeTemplate.fromAnnotation(typeFactory, hint);
        if (template.dataType != null) {
            return FunctionArgumentTemplate.of(template.dataType);
        }
        if (template.inputGroup != null) {
            return FunctionArgumentTemplate.of(template.inputGroup);
        }
        throw ExtractionUtils.extractionError("Data type hint does neither specify a data type nor input group for use as function argument.", new Object[0]);
    }

    @FunctionHint
    private static class DefaultAnnotationHelper {
        private DefaultAnnotationHelper() {
        }
    }
}

