/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionMappingExtractor;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionSignatureTemplate;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.InputTypeStrategies;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.inference.TypeStrategy;

@Internal
public final class TypeInferenceExtractor {
    public static TypeInference forScalarFunction(DataTypeFactory typeFactory, Class<? extends ScalarFunction> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "eval", FunctionMappingExtractor.createParameterSignatureExtraction(0), null, FunctionMappingExtractor.createReturnTypeResultExtraction(), FunctionMappingExtractor.createParameterAndReturnTypeVerification());
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor);
    }

    public static TypeInference forAggregateFunction(DataTypeFactory typeFactory, Class<? extends AggregateFunction<?, ?>> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "accumulate", FunctionMappingExtractor.createParameterSignatureExtraction(1), FunctionMappingExtractor.createGenericResultExtraction(AggregateFunction.class, 1), FunctionMappingExtractor.createGenericResultExtraction(AggregateFunction.class, 0), FunctionMappingExtractor.createParameterWithAccumulatorVerification());
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor);
    }

    public static TypeInference forTableFunction(DataTypeFactory typeFactory, Class<? extends TableFunction<?>> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "eval", FunctionMappingExtractor.createParameterSignatureExtraction(0), null, FunctionMappingExtractor.createGenericResultExtraction(TableFunction.class, 0), FunctionMappingExtractor.createParameterVerification());
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor);
    }

    public static TypeInference forTableAggregateFunction(DataTypeFactory typeFactory, Class<? extends TableAggregateFunction<?, ?>> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "accumulate", FunctionMappingExtractor.createParameterSignatureExtraction(1), FunctionMappingExtractor.createGenericResultExtraction(TableAggregateFunction.class, 1), FunctionMappingExtractor.createGenericResultExtraction(TableAggregateFunction.class, 0), FunctionMappingExtractor.createParameterWithAccumulatorVerification());
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor);
    }

    public static TypeInference forAsyncTableFunction(DataTypeFactory typeFactory, Class<? extends AsyncTableFunction<?>> function) {
        FunctionMappingExtractor mappingExtractor = new FunctionMappingExtractor(typeFactory, function, "eval", FunctionMappingExtractor.createParameterSignatureExtraction(1), null, FunctionMappingExtractor.createGenericResultExtraction(AsyncTableFunction.class, 0), FunctionMappingExtractor.createParameterWithArgumentVerification(CompletableFuture.class));
        return TypeInferenceExtractor.extractTypeInference(mappingExtractor);
    }

    private static TypeInference extractTypeInference(FunctionMappingExtractor mappingExtractor) {
        try {
            return TypeInferenceExtractor.extractTypeInferenceOrError(mappingExtractor);
        }
        catch (Throwable t) {
            throw ExtractionUtils.extractionError(t, "Could not extract a valid type inference for function class '%s'. Please check for implementation mistakes and/or provide a corresponding hint.", mappingExtractor.getFunction().getName());
        }
    }

    private static TypeInference extractTypeInferenceOrError(FunctionMappingExtractor mappingExtractor) {
        Map<FunctionSignatureTemplate, FunctionResultTemplate> outputMapping = mappingExtractor.extractOutputMapping();
        if (!mappingExtractor.hasAccumulator()) {
            return TypeInferenceExtractor.buildInference(null, outputMapping);
        }
        Map<FunctionSignatureTemplate, FunctionResultTemplate> accumulatorMapping = mappingExtractor.extractAccumulatorMapping();
        return TypeInferenceExtractor.buildInference(accumulatorMapping, outputMapping);
    }

    private static TypeInference buildInference(@Nullable Map<FunctionSignatureTemplate, FunctionResultTemplate> accumulatorMapping, Map<FunctionSignatureTemplate, FunctionResultTemplate> outputMapping) {
        TypeInference.Builder builder = TypeInference.newBuilder();
        TypeInferenceExtractor.configureNamedArguments(builder, outputMapping);
        TypeInferenceExtractor.configureTypedArguments(builder, outputMapping);
        builder.inputTypeStrategy(TypeInferenceExtractor.translateInputTypeStrategy(outputMapping));
        if (accumulatorMapping != null) {
            if (!accumulatorMapping.keySet().equals(outputMapping.keySet())) {
                throw ExtractionUtils.extractionError("Mismatch between accumulator signature and output signature. Both intermediate and output results must be derived from the same input strategy.", new Object[0]);
            }
            builder.accumulatorTypeStrategy(TypeInferenceExtractor.translateResultTypeStrategy(accumulatorMapping));
        }
        builder.outputTypeStrategy(TypeInferenceExtractor.translateResultTypeStrategy(outputMapping));
        return builder.build();
    }

    private static void configureNamedArguments(TypeInference.Builder builder, Map<FunctionSignatureTemplate, FunctionResultTemplate> outputMapping) {
        Set<FunctionSignatureTemplate> signatures = outputMapping.keySet();
        if (signatures.stream().anyMatch(s -> s.isVarArgs || s.argumentNames == null)) {
            return;
        }
        Set argumentNames = signatures.stream().map(s -> {
            assert (s.argumentNames != null);
            return Arrays.asList(s.argumentNames);
        }).collect(Collectors.toSet());
        if (argumentNames.size() != 1) {
            return;
        }
        builder.namedArguments((List)argumentNames.iterator().next());
    }

    private static void configureTypedArguments(TypeInference.Builder builder, Map<FunctionSignatureTemplate, FunctionResultTemplate> outputMapping) {
        if (outputMapping.size() != 1) {
            return;
        }
        FunctionSignatureTemplate signature = outputMapping.keySet().iterator().next();
        List<DataType> dataTypes = signature.argumentTemplates.stream().map(a -> a.dataType).collect(Collectors.toList());
        if (!signature.isVarArgs && dataTypes.stream().allMatch(Objects::nonNull)) {
            builder.typedArguments(dataTypes);
        }
    }

    private static TypeStrategy translateResultTypeStrategy(Map<FunctionSignatureTemplate, FunctionResultTemplate> resultMapping) {
        Map<InputTypeStrategy, TypeStrategy> mappings = resultMapping.entrySet().stream().collect(Collectors.toMap(e -> ((FunctionSignatureTemplate)e.getKey()).toInputTypeStrategy(), e -> ((FunctionResultTemplate)e.getValue()).toTypeStrategy()));
        return TypeStrategies.mapping(mappings);
    }

    private static InputTypeStrategy translateInputTypeStrategy(Map<FunctionSignatureTemplate, FunctionResultTemplate> outputMapping) {
        return outputMapping.keySet().stream().map(FunctionSignatureTemplate::toInputTypeStrategy).reduce((xva$0, xva$1) -> InputTypeStrategies.or(xva$0, xva$1)).orElse(InputTypeStrategies.sequence(new ArgumentTypeStrategy[0]));
    }
}

