/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.strategies.ExplicitTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MappingTypeStrategy;
import org.apache.flink.table.types.inference.strategies.MissingTypeStrategy;
import org.apache.flink.table.types.inference.strategies.UseArgumentTypeStrategy;

@Internal
public final class TypeStrategies {
    public static final TypeStrategy MISSING = new MissingTypeStrategy();
    public static final TypeStrategy ROW = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        DataTypes.Field[] fields = (DataTypes.Field[])IntStream.range(0, argumentDataTypes.size()).mapToObj(idx -> DataTypes.FIELD("f" + idx, (DataType)argumentDataTypes.get(idx))).toArray(DataTypes.Field[]::new);
        return Optional.of(DataTypes.ROW(fields).notNull());
    };
    public static final TypeStrategy MAP = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes.size() < 2) {
            return Optional.empty();
        }
        return Optional.of(DataTypes.MAP(argumentDataTypes.get(0), argumentDataTypes.get(1)).notNull());
    };
    public static final TypeStrategy ARRAY = callContext -> {
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        if (argumentDataTypes.size() < 1) {
            return Optional.empty();
        }
        return Optional.of(DataTypes.ARRAY(argumentDataTypes.get(0)).notNull());
    };

    public static TypeStrategy explicit(DataType dataType) {
        return new ExplicitTypeStrategy(dataType);
    }

    public static TypeStrategy argument(int pos) {
        return new UseArgumentTypeStrategy(pos);
    }

    public static TypeStrategy mapping(Map<InputTypeStrategy, TypeStrategy> mappings) {
        return new MappingTypeStrategy(mappings);
    }

    private TypeStrategies() {
    }
}

